/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.SubmissionDisplayer;
import org.apache.sqoop.shell.utils.TableDisplayer;
import org.apache.sqoop.validation.Status;

public class ShowSubmissionFunction
extends SqoopFunction {
    protected ShowSubmissionFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_all_submissions"));
        OptionBuilder.withLongOpt((String)"detail");
        this.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"jid");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_all_submissions_jid"));
        OptionBuilder.withLongOpt((String)"jid");
        this.addOption(OptionBuilder.create((char)'j'));
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("detail")) {
            if (line.hasOption("jid")) {
                this.showSubmissions(this.getLong(line, "jid"));
            } else {
                this.showSubmissions(null);
            }
        } else if (line.hasOption("jid")) {
            this.showSummary(this.getLong(line, "jid"));
        } else {
            this.showSummary(null);
        }
        return Status.FINE;
    }

    private void showSummary(Long jid) {
        List submissions = jid == null ? ShellEnvironment.client.getSubmissions() : ShellEnvironment.client.getSubmissionsForJob(jid.longValue());
        LinkedList<String> header = new LinkedList<String>();
        header.add(ShellEnvironment.resourceString("table.header.jid"));
        header.add(ShellEnvironment.resourceString("table.header.eid"));
        header.add(ShellEnvironment.resourceString("table.header.status"));
        header.add(ShellEnvironment.resourceString("table.header.date"));
        LinkedList<String> jids = new LinkedList<String>();
        LinkedList<String> eids = new LinkedList<String>();
        LinkedList<String> status = new LinkedList<String>();
        LinkedList<String> dates = new LinkedList<String>();
        for (MSubmission submission : submissions) {
            jids.add(String.valueOf(submission.getJobId()));
            eids.add(String.valueOf(submission.getExternalId()));
            status.add(submission.getStatus().toString());
            dates.add(submission.getLastUpdateDate().toString());
        }
        TableDisplayer.display(header, jids, eids, status, dates);
    }

    private void showSubmissions(Long jid) {
        List submissions = jid == null ? ShellEnvironment.client.getSubmissions() : ShellEnvironment.client.getSubmissionsForJob(jid.longValue());
        for (MSubmission submission : submissions) {
            SubmissionDisplayer.displaySubmission(submission);
        }
    }
}

