/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.shell.utils.TableDisplayer;
import org.apache.sqoop.validation.Status;

public class ShowConnectionFunction
extends SqoopFunction {
    protected ShowConnectionFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_all_conns"));
        OptionBuilder.withLongOpt((String)"all");
        this.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"xid");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_conn_xid"));
        OptionBuilder.withLongOpt((String)"xid");
        this.addOption(OptionBuilder.create((char)'x'));
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("all")) {
            this.showConnections();
        } else if (line.hasOption("xid")) {
            this.showConnection(this.getLong(line, "xid"));
        } else {
            this.showSummary();
        }
        return Status.FINE;
    }

    private void showSummary() {
        List connections = ShellEnvironment.client.getConnections();
        LinkedList<String> header = new LinkedList<String>();
        header.add(ShellEnvironment.resourceString("table.header.id"));
        header.add(ShellEnvironment.resourceString("table.header.name"));
        header.add(ShellEnvironment.resourceString("table.header.connector"));
        header.add(ShellEnvironment.resourceString("table.header.enabled"));
        LinkedList<String> ids = new LinkedList<String>();
        LinkedList<String> names = new LinkedList<String>();
        LinkedList<String> connectors = new LinkedList<String>();
        LinkedList<String> availabilities = new LinkedList<String>();
        for (MConnection connection : connections) {
            ids.add(String.valueOf(connection.getPersistenceId()));
            names.add(connection.getName());
            connectors.add(String.valueOf(connection.getConnectorId()));
            availabilities.add(String.valueOf(connection.getEnabled()));
        }
        TableDisplayer.display(header, ids, names, connectors, availabilities);
    }

    private void showConnections() {
        List connections = ShellEnvironment.client.getConnections();
        ShellEnvironment.printlnResource("show.prompt_conns_to_show", connections.size());
        for (MConnection connection : connections) {
            this.displayConnection(connection);
        }
    }

    private void showConnection(Long xid) {
        MConnection connection = ShellEnvironment.client.getConnection(xid.longValue());
        ShellEnvironment.printlnResource("show.prompt_conns_to_show", 1);
        this.displayConnection(connection);
    }

    private void displayConnection(MConnection connection) {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        ShellEnvironment.printlnResource("show.prompt_conn_info", connection.getPersistenceId(), connection.getName(), connection.getEnabled(), connection.getCreationUser(), formatter.format(connection.getCreationDate()), connection.getLastUpdateUser(), formatter.format(connection.getLastUpdateDate()));
        long connectorId = connection.getConnectorId();
        ShellEnvironment.printlnResource("show.prompt_conn_cid_info", connectorId);
        FormDisplayer.displayForms(connection.getConnectorPart().getForms(), ShellEnvironment.client.getResourceBundle(connectorId));
        FormDisplayer.displayForms(connection.getFrameworkPart().getForms(), ShellEnvironment.client.getFrameworkResourceBundle());
    }
}

