/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.util.List;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.ShowConnectionFunction;
import org.apache.sqoop.shell.ShowConnectorFunction;
import org.apache.sqoop.shell.ShowFrameworkFunction;
import org.apache.sqoop.shell.ShowJobFunction;
import org.apache.sqoop.shell.ShowOptionFunction;
import org.apache.sqoop.shell.ShowServerFunction;
import org.apache.sqoop.shell.ShowSubmissionFunction;
import org.apache.sqoop.shell.ShowVersionFunction;
import org.apache.sqoop.shell.SqoopCommand;
import org.codehaus.groovy.tools.shell.Shell;

public class ShowCommand
extends SqoopCommand {
    private ShowServerFunction serverFunction;
    private ShowVersionFunction versionFunction;
    private ShowConnectorFunction connectorFunction;
    private ShowJobFunction jobFunction;
    private ShowSubmissionFunction submissionFunction;
    private ShowFrameworkFunction frameworkFunction;
    private ShowConnectionFunction connectionFunction;
    private ShowOptionFunction optionFunction;

    protected ShowCommand(Shell shell) {
        super(shell, "show", "\\sh", new String[]{"server", "version", "connector", "framework", "connection", "job", "submission", "option"}, "Show", "Info");
    }

    @Override
    public Object executeCommand(List args) {
        if (args.size() == 0) {
            ShellEnvironment.printlnResource("show.usage", this.getUsage());
            return null;
        }
        String func = (String)args.get(0);
        if (func.equals("server")) {
            if (this.serverFunction == null) {
                this.serverFunction = new ShowServerFunction();
            }
            return this.serverFunction.execute(args);
        }
        if (func.equals("version")) {
            if (this.versionFunction == null) {
                this.versionFunction = new ShowVersionFunction();
            }
            return this.versionFunction.execute(args);
        }
        if (func.equals("connector")) {
            if (this.connectorFunction == null) {
                this.connectorFunction = new ShowConnectorFunction();
            }
            return this.connectorFunction.execute(args);
        }
        if (func.equals("framework")) {
            if (this.frameworkFunction == null) {
                this.frameworkFunction = new ShowFrameworkFunction();
            }
            return this.frameworkFunction.execute(args);
        }
        if (func.equals("connection")) {
            if (this.connectionFunction == null) {
                this.connectionFunction = new ShowConnectionFunction();
            }
            return this.connectionFunction.execute(args);
        }
        if (func.equals("job")) {
            if (this.jobFunction == null) {
                this.jobFunction = new ShowJobFunction();
            }
            return this.jobFunction.execute(args);
        }
        if (func.equals("submission")) {
            if (this.submissionFunction == null) {
                this.submissionFunction = new ShowSubmissionFunction();
            }
            return this.submissionFunction.execute(args);
        }
        if (func.equals("option")) {
            if (this.optionFunction == null) {
                this.optionFunction = new ShowOptionFunction();
            }
            return this.optionFunction.execute(args);
        }
        ShellEnvironment.printlnResource("args.function.unknown", func);
        return null;
    }
}

