/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.validation.Status;

public class SetServerFunction
extends SqoopFunction {
    protected SetServerFunction() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"host");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("set.host_description"));
        OptionBuilder.withLongOpt((String)"host");
        this.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("set.port_description"));
        OptionBuilder.withLongOpt((String)"port");
        this.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"webapp");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("set.webapp_description"));
        OptionBuilder.withLongOpt((String)"webapp");
        this.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("set.url_description"));
        OptionBuilder.withLongOpt((String)"url");
        this.addOption(OptionBuilder.create((char)'u'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (line.getArgs().length == 1) {
            ShellEnvironment.printlnResource("set.server_usage");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("url")) {
            ShellEnvironment.setServerUrl(line.getOptionValue("url"));
            if (line.hasOption("host") || line.hasOption("port") || line.hasOption("webapp")) {
                ShellEnvironment.printlnResource("set.server_ignored");
            }
        } else {
            if (line.hasOption("host")) {
                ShellEnvironment.setServerHost(line.getOptionValue("host"));
            }
            if (line.hasOption("port")) {
                ShellEnvironment.setServerPort(line.getOptionValue("port"));
            }
            if (line.hasOption("webapp")) {
                ShellEnvironment.setServerWebapp(line.getOptionValue("webapp"));
            }
        }
        ShellEnvironment.printlnResource("set.server_successful");
        return Status.FINE;
    }
}

