/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.validation.Status;

public class SetOptionFunction
extends SqoopFunction {
    protected SetOptionFunction() {
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("set.prompt_opt_name"));
        OptionBuilder.withLongOpt((String)"name");
        this.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("set.prompt_opt_value"));
        OptionBuilder.withLongOpt((String)"value");
        this.addOption(OptionBuilder.create((char)'v'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (!line.hasOption("name")) {
            ShellEnvironment.printlnResource("args.name_missing");
            return false;
        }
        if (!line.hasOption("value")) {
            ShellEnvironment.printlnResource("args.value_missing");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (!line.hasOption("name")) {
            ShellEnvironment.printlnResource("args.name_missing");
            return null;
        }
        if (!line.hasOption("value")) {
            ShellEnvironment.printlnResource("args.value_missing");
            return null;
        }
        return this.handleOptionSetting(line.getOptionValue("name"), line.getOptionValue("value"));
    }

    private Status handleOptionSetting(String name, String value) {
        if (name.equals("verbose")) {
            boolean newValue = false;
            if (value.equals("1") || value.equals("true")) {
                newValue = true;
            }
            ShellEnvironment.setVerbose(newValue);
            ShellEnvironment.printlnResource("set.verbose_changed", newValue);
            return Status.FINE;
        }
        if (name.equals("poll-timeout")) {
            long newValue = 0L;
            try {
                newValue = Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                newValue = ShellEnvironment.getPollTimeout();
            }
            ShellEnvironment.setPollTimeout(newValue);
            ShellEnvironment.printlnResource("set.poll_timeout_changed", newValue);
            return Status.FINE;
        }
        ShellEnvironment.printlnResource("set.unknown_opt_ignored", name);
        return null;
    }
}

