/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.validation.Status;

public class DisableConnectionFunction
extends SqoopFunction {
    public DisableConnectionFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.conn_id"));
        OptionBuilder.withLongOpt((String)"xid");
        OptionBuilder.hasArg();
        this.addOption(OptionBuilder.create((char)'x'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (!line.hasOption("xid")) {
            ShellEnvironment.printlnResource("args.xid_missing");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        ShellEnvironment.client.enableConnection(this.getLong(line, "xid"), false);
        return Status.FINE;
    }
}

