/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import jline.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.ConnectionDynamicFormOptions;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.shell.utils.FormFiller;
import org.apache.sqoop.shell.utils.FormOptions;
import org.apache.sqoop.validation.Status;

public class CreateConnectionFunction
extends SqoopFunction {
    public CreateConnectionFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.connector_id"));
        OptionBuilder.withLongOpt((String)"cid");
        OptionBuilder.hasArg();
        this.addOption(OptionBuilder.create((char)'c'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (!line.hasOption("cid")) {
            ShellEnvironment.printlnResource("args.cid_missing");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) throws IOException {
        return this.createConnection(this.getLong(line, "cid"), line.getArgList(), isInteractive);
    }

    private Status createConnection(long connectorId, List<String> args, boolean isInteractive) throws IOException {
        ShellEnvironment.printlnResource("create.creating_conn", connectorId);
        ConsoleReader reader = new ConsoleReader();
        MConnection connection = ShellEnvironment.client.newConnection(connectorId);
        ResourceBundle connectorBundle = ShellEnvironment.client.getResourceBundle(connectorId);
        ResourceBundle frameworkBundle = ShellEnvironment.client.getFrameworkResourceBundle();
        Status status = Status.FINE;
        if (isInteractive) {
            ShellEnvironment.printlnResource("prompt.fill_conn_metadata");
            do {
                if (!status.canProceed()) {
                    FormFiller.errorIntroduction();
                }
                if (FormFiller.fillConnection(reader, connection, connectorBundle, frameworkBundle)) continue;
                return null;
            } while (!(status = ShellEnvironment.client.createConnection(connection)).canProceed());
        } else {
            ConnectionDynamicFormOptions options = new ConnectionDynamicFormOptions();
            options.prepareOptions(connection);
            CommandLine line = FormOptions.parseOptions(options, 0, args, false);
            if (FormFiller.fillConnection(line, connection)) {
                status = ShellEnvironment.client.createConnection(connection);
                if (!status.canProceed()) {
                    FormFiller.printConnectionValidationMessages(connection);
                    return null;
                }
            } else {
                FormFiller.printConnectionValidationMessages(connection);
                return null;
            }
        }
        FormDisplayer.displayFormWarning((MAccountableEntity)connection);
        ShellEnvironment.printlnResource("create.conn_successful", status.name(), connection.getPersistenceId());
        return status;
    }
}

