/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import jline.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.FormFiller;
import org.apache.sqoop.shell.utils.FormOptions;
import org.apache.sqoop.shell.utils.JobDynamicFormOptions;
import org.apache.sqoop.validation.Status;

public class CloneJobFunction
extends SqoopFunction {
    public CloneJobFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.job_id"));
        OptionBuilder.withLongOpt((String)"jid");
        OptionBuilder.hasArg();
        this.addOption(OptionBuilder.create((char)'j'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (!line.hasOption("jid")) {
            ShellEnvironment.printlnResource("args.jid_missing");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) throws IOException {
        return this.cloneJob(this.getLong(line, "jid"), line.getArgList(), isInteractive);
    }

    private Status cloneJob(Long jobId, List<String> args, boolean isInteractive) throws IOException {
        ShellEnvironment.printlnResource("clone.cloning_job", jobId);
        ConsoleReader reader = new ConsoleReader();
        MJob job = ShellEnvironment.client.getJob(jobId.longValue());
        job.setPersistenceId(-1L);
        ResourceBundle connectorBundle = ShellEnvironment.client.getResourceBundle(job.getConnectorId());
        ResourceBundle frameworkBundle = ShellEnvironment.client.getFrameworkResourceBundle();
        Status status = Status.FINE;
        job.setPersistenceId(-1L);
        if (isInteractive) {
            ShellEnvironment.printlnResource("prompt.update_job_metadata");
            do {
                if (!status.canProceed()) {
                    FormFiller.errorIntroduction();
                }
                if (FormFiller.fillJob(reader, job, connectorBundle, frameworkBundle)) continue;
                return null;
            } while (!(status = ShellEnvironment.client.createJob(job)).canProceed());
        } else {
            JobDynamicFormOptions options = new JobDynamicFormOptions();
            options.prepareOptions(job);
            CommandLine line = FormOptions.parseOptions(options, 0, args, false);
            if (FormFiller.fillJob(line, job)) {
                status = ShellEnvironment.client.createJob(job);
                if (!status.canProceed()) {
                    FormFiller.printJobValidationMessages(job);
                    return null;
                }
            } else {
                FormFiller.printJobValidationMessages(job);
                return null;
            }
        }
        ShellEnvironment.printlnResource("clone.job.successful", status.name(), job.getPersistenceId());
        return status;
    }
}

