/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.common.SqoopResponseCode;
import org.apache.sqoop.error.code.CoreError;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.ThrowableBean;
import org.apache.sqoop.server.RequestContext;

public class SqoopProtocolServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(SqoopProtocolServlet.class);

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestContext rctx = new RequestContext(req, resp);
        try {
            JsonBean bean = this.handleGetRequest(rctx);
            if (bean != null) {
                this.sendSuccessResponse(rctx, bean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception in GET " + rctx.getPath()), (Throwable)ex);
            this.sendErrorResponse(rctx, ex);
        }
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestContext rctx = new RequestContext(req, resp);
        try {
            JsonBean bean = this.handlePostRequest(rctx);
            if (bean != null) {
                this.sendSuccessResponse(rctx, bean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception in POST " + rctx.getPath()), (Throwable)ex);
            this.sendErrorResponse(rctx, ex);
        }
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestContext rctx = new RequestContext(req, resp);
        try {
            JsonBean bean = this.handlePutRequest(rctx);
            if (bean != null) {
                this.sendSuccessResponse(rctx, bean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception in PUT " + rctx.getPath()), (Throwable)ex);
            this.sendErrorResponse(rctx, ex);
        }
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestContext rctx = new RequestContext(req, resp);
        try {
            JsonBean bean = this.handleDeleteRequest(rctx);
            if (bean != null) {
                this.sendSuccessResponse(rctx, bean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Exception in DELETE " + rctx.getPath()), (Throwable)ex);
            this.sendErrorResponse(rctx, ex);
        }
    }

    private void sendSuccessResponse(RequestContext ctx, JsonBean bean) throws IOException {
        HttpServletResponse response = ctx.getResponse();
        response.setStatus(200);
        this.setContentType(response);
        this.setHeaders(response, SqoopResponseCode.SQOOP_1000);
        String responseString = bean.extract(true).toJSONString();
        response.getWriter().write(responseString);
        response.getWriter().flush();
    }

    private void sendErrorResponse(RequestContext ctx, Exception ex) throws IOException {
        HttpServletResponse response = ctx.getResponse();
        this.setContentType(response);
        this.setHeaders(response, SqoopResponseCode.SQOOP_2000);
        if (ex != null) {
            Object ec = null;
            ec = ex instanceof SqoopException ? ((SqoopException)ex).getErrorCode() : CoreError.CORE_0000;
            response.setHeader("sqoop-internal-error-code", ec.getCode());
            response.setHeader("sqoop-internal-error-message", ex.getMessage());
            ThrowableBean throwableBean = new ThrowableBean((Throwable)ex);
            response.setStatus(500);
            response.getWriter().write(throwableBean.extract(true).toJSONString());
        } else {
            response.sendError(500);
        }
    }

    private void setContentType(HttpServletResponse response) {
        response.setContentType("application/json; charset=\"UTF-8\"");
    }

    private void setHeaders(HttpServletResponse response, SqoopResponseCode code) {
        response.setHeader("sqoop-error-code", code.getCode());
        response.setHeader("sqoop-error-message", code.getMessage());
    }

    protected JsonBean handleGetRequest(RequestContext ctx) throws Exception {
        super.doGet(ctx.getRequest(), ctx.getResponse());
        return null;
    }

    protected JsonBean handlePostRequest(RequestContext ctx) throws Exception {
        super.doPost(ctx.getRequest(), ctx.getResponse());
        return null;
    }

    protected JsonBean handlePutRequest(RequestContext ctx) throws Exception {
        super.doPut(ctx.getRequest(), ctx.getResponse());
        return null;
    }

    protected JsonBean handleDeleteRequest(RequestContext ctx) throws Exception {
        super.doDelete(ctx.getRequest(), ctx.getResponse());
        return null;
    }
}

