/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.common.VersionInfo;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.VersionBean;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;

public class VersionRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(VersionRequestHandler.class);
    public static final String CURRENT_REST_API_VERSION = "v1";
    private final VersionBean versionBean;

    public VersionRequestHandler() {
        String[] apiVersions = new String[]{CURRENT_REST_API_VERSION};
        this.versionBean = new VersionBean(VersionInfo.getBuildVersion(), VersionInfo.getSourceRevision(), VersionInfo.getBuildDate(), VersionInfo.getUser(), VersionInfo.getSourceUrl(), apiVersions);
        LOG.info((Object)"VersionRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        if (ctx.getMethod() != RequestContext.Method.GET) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0002, "Unsupported HTTP method for version:" + ctx.getMethod());
        }
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "show", "version", "");
        return this.versionBean;
    }
}

