/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.handler.HandlerUtils;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.SubmissionsBean;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.security.authorization.AuthorizationEngine;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;

public class SubmissionRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(SubmissionRequestHandler.class);

    public SubmissionRequestHandler() {
        LOG.info((Object)"SubmissionRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        if (ctx.getMethod() != RequestContext.Method.GET) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0002, "Unsupported HTTP method for connector:" + ctx.getMethod());
        }
        String jobIdentifier = ctx.getLastURLElement();
        Repository repository = RepositoryManager.getInstance().getRepository();
        if (ctx.getParameterValue("jname") != null) {
            jobIdentifier = ctx.getParameterValue("jname");
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "submissionsByJob", jobIdentifier);
            long jobId = HandlerUtils.getJobIdFromIdentifier((String)jobIdentifier, (Repository)repository);
            return this.getSubmissionsForJob(jobId);
        }
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "submissions", "all");
        return this.getSubmissions();
    }

    private JsonBean getSubmissions() {
        List submissions = RepositoryManager.getInstance().getRepository().findSubmissions();
        submissions = AuthorizationEngine.filterSubmission((List)submissions);
        return new SubmissionsBean(submissions);
    }

    private JsonBean getSubmissionsForJob(long jid) {
        AuthorizationEngine.statusJob((String)String.valueOf(jid));
        List submissions = RepositoryManager.getInstance().getRepository().findSubmissionsForJob(jid);
        return new SubmissionsBean(submissions);
    }
}

