/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.handler.HandlerUtils;
import org.apache.sqoop.handler.LinkRequestHandler;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.LinkBean;
import org.apache.sqoop.json.LinksBean;
import org.apache.sqoop.json.ValidationResultBean;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.security.AuthorizationManager;
import org.apache.sqoop.security.authorization.AuthorizationEngine;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.json.simple.JSONObject;

public class LinkRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(LinkRequestHandler.class);
    static final String ENABLE = "enable";
    static final String DISABLE = "disable";
    static final String LINKS_PATH = "links";
    static final String LINK_PATH = "link";

    public LinkRequestHandler() {
        LOG.info((Object)"LinkRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        switch (1.$SwitchMap$org$apache$sqoop$server$RequestContext$Method[ctx.getMethod().ordinal()]) {
            case 1: {
                return this.getLinks(ctx);
            }
            case 2: {
                return this.createUpdateLink(ctx, true);
            }
            case 3: {
                if (ctx.getLastURLElement().equals(ENABLE)) {
                    return this.enableLink(ctx, true);
                }
                if (ctx.getLastURLElement().equals(DISABLE)) {
                    return this.enableLink(ctx, false);
                }
                return this.createUpdateLink(ctx, false);
            }
            case 4: {
                return this.deleteLink(ctx);
            }
        }
        return null;
    }

    private JsonBean deleteLink(RequestContext ctx) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        String linkIdentifier = ctx.getLastURLElement();
        long linkId = HandlerUtils.getLinkIdFromIdentifier((String)linkIdentifier, (Repository)repository);
        AuthorizationEngine.deleteLink((String)String.valueOf(linkId));
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "delete", LINK_PATH, linkIdentifier);
        repository.deleteLink(linkId);
        MResource resource = new MResource(String.valueOf(linkId), MResource.TYPE.LINK);
        AuthorizationManager.getAuthorizationHandler().removeResource(resource);
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean createUpdateLink(RequestContext ctx, boolean create) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        LinkBean linkBean = new LinkBean();
        try {
            JSONObject postData = JSONUtils.parse((Reader)ctx.getRequest().getReader());
            linkBean.restore(postData);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Can't read request content", (Throwable)e);
        }
        String username = ctx.getUserName();
        List links = linkBean.getLinks();
        if (links.size() != 1) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Expected one link while parsing JSON request but got " + links.size());
        }
        MLink postedLink = (MLink)links.get(0);
        if (create) {
            AuthorizationEngine.createLink((String)String.valueOf(postedLink.getConnectorId()));
        } else {
            AuthorizationEngine.updateLink((String)String.valueOf(postedLink.getConnectorId()), (String)String.valueOf(postedLink.getPersistenceId()));
        }
        MLinkConfig linkConfig = ConnectorManager.getInstance().getConnectorConfigurable(postedLink.getConnectorId()).getLinkConfig();
        if (!linkConfig.equals((Object)postedLink.getConnectorLinkConfig())) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Detected incorrect link config structure");
        }
        if (!create) {
            String linkIdentifier = ctx.getLastURLElement();
            long linkId = HandlerUtils.getLinkIdFromIdentifier((String)linkIdentifier, (Repository)repository);
            if (postedLink.getPersistenceId() == -1L) {
                MLink existingLink = repository.findLink(linkId);
                postedLink.setPersistenceId(existingLink.getPersistenceId());
            }
        }
        SqoopConnector connector = ConnectorManager.getInstance().getSqoopConnector(postedLink.getConnectorId());
        ConfigValidationResult connectorLinkConfigValidation = ConfigUtils.validateConfigs((List)postedLink.getConnectorLinkConfig().getConfigs(), (Class)connector.getLinkConfigurationClass());
        ValidationResultBean linkValidationBean = new ValidationResultBean(new ConfigValidationResult[]{connectorLinkConfigValidation});
        if (connectorLinkConfigValidation.getStatus().canProceed()) {
            if (create) {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "create", LINK_PATH, String.valueOf(postedLink.getPersistenceId()));
                postedLink.setCreationUser(username);
                postedLink.setLastUpdateUser(username);
                repository.createLink(postedLink);
                linkValidationBean.setId(Long.valueOf(postedLink.getPersistenceId()));
            } else {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "update", LINK_PATH, String.valueOf(postedLink.getPersistenceId()));
                postedLink.setLastUpdateUser(username);
                repository.updateLink(postedLink);
            }
        }
        return linkValidationBean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonBean getLinks(RequestContext ctx) {
        String identifier = ctx.getLastURLElement();
        Locale locale = ctx.getAcceptLanguageHeader();
        Repository repository = RepositoryManager.getInstance().getRepository();
        if (ctx.getParameterValue("cname") != null) {
            identifier = ctx.getParameterValue("cname");
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "linksByConnector", identifier);
            if (repository.findConnector(identifier) == null) throw new SqoopException((ErrorCode)ServerError.SERVER_0005, "Invalid connector: " + identifier + " name for links given");
            long connectorId = repository.findConnector(identifier).getPersistenceId();
            List linkList = repository.findLinksForConnector(connectorId);
            linkList = AuthorizationEngine.filterResource((MResource.TYPE)MResource.TYPE.LINK, (List)linkList);
            return this.createLinksBean(linkList, locale);
        }
        if (ctx.getPath().contains(LINKS_PATH) || ctx.getPath().contains(LINK_PATH) && identifier.equals("all")) {
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", LINKS_PATH, "all");
            List linkList = repository.findLinks();
            linkList = AuthorizationEngine.filterResource((MResource.TYPE)MResource.TYPE.LINK, (List)linkList);
            return this.createLinksBean(linkList, locale);
        }
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", LINK_PATH, identifier);
        long linkId = HandlerUtils.getLinkIdFromIdentifier((String)identifier, (Repository)repository);
        MLink link = repository.findLink(linkId);
        AuthorizationEngine.readLink((String)String.valueOf(link.getPersistenceId()));
        return this.createLinkBean(Arrays.asList(link), locale);
    }

    private LinkBean createLinkBean(List<MLink> links, Locale locale) {
        LinkBean linkBean = new LinkBean(links);
        this.addLink(links, locale, linkBean);
        return linkBean;
    }

    private LinksBean createLinksBean(List<MLink> links, Locale locale) {
        LinksBean linksBean = new LinksBean(links);
        this.addLink(links, locale, (LinkBean)linksBean);
        return linksBean;
    }

    private void addLink(List<MLink> links, Locale locale, LinkBean bean) {
        for (MLink link : links) {
            long connectorId = link.getConnectorId();
            if (bean.hasConnectorConfigBundle(Long.valueOf(connectorId))) continue;
            bean.addConnectorConfigBundle(Long.valueOf(connectorId), ConnectorManager.getInstance().getResourceBundle(connectorId, locale));
        }
    }

    private JsonBean enableLink(RequestContext ctx, boolean enabled) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        String[] elements = ctx.getUrlElements();
        String linkIdentifier = elements[elements.length - 2];
        long linkId = HandlerUtils.getLinkIdFromIdentifier((String)linkIdentifier, (Repository)repository);
        AuthorizationEngine.enableDisableLink((String)String.valueOf(linkId));
        repository.enableLink(linkId, enabled);
        return JsonBean.EMPTY_BEAN;
    }
}

