/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.driver.Driver;
import org.apache.sqoop.driver.JobManager;
import org.apache.sqoop.handler.HandlerUtils;
import org.apache.sqoop.handler.JobRequestHandler;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.JobsBean;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.SubmissionBean;
import org.apache.sqoop.json.ValidationResultBean;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.model.MToConfig;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.request.HttpEventContext;
import org.apache.sqoop.security.AuthorizationManager;
import org.apache.sqoop.security.authorization.AuthorizationEngine;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.apache.sqoop.validation.Status;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(JobRequestHandler.class);
    static final String JOBS_PATH = "jobs";
    static final String JOB_PATH = "job";
    static final String STATUS = "status";

    public JobRequestHandler() {
        LOG.info((Object)"JobRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        LOG.info((Object)"Got job request");
        switch (1.$SwitchMap$org$apache$sqoop$server$RequestContext$Method[ctx.getMethod().ordinal()]) {
            case 1: {
                if ("status".equals(ctx.getLastURLElement())) {
                    return this.getJobStatus(ctx);
                }
                return this.getJobs(ctx);
            }
            case 2: {
                return this.createUpdateJob(ctx, true);
            }
            case 3: {
                JobAction action = JobAction.fromString((String)ctx.getLastURLElement());
                if (action != null) {
                    switch (1.$SwitchMap$org$apache$sqoop$handler$JobRequestHandler$JobAction[action.ordinal()]) {
                        case 1: {
                            return this.enableJob(ctx, true);
                        }
                        case 2: {
                            return this.enableJob(ctx, false);
                        }
                        case 3: {
                            return this.startJob(ctx);
                        }
                        case 4: {
                            return this.stopJob(ctx);
                        }
                    }
                }
                return this.createUpdateJob(ctx, false);
            }
            case 4: {
                return this.deleteJob(ctx);
            }
        }
        return null;
    }

    private JsonBean deleteJob(RequestContext ctx) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        String jobIdentifier = ctx.getLastURLElement();
        long jobId = HandlerUtils.getJobIdFromIdentifier((String)jobIdentifier, (Repository)repository);
        AuthorizationEngine.deleteJob((String)String.valueOf(jobId));
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "delete", "job", jobIdentifier);
        repository.deleteJob(jobId);
        MResource resource = new MResource(String.valueOf(jobId), MResource.TYPE.JOB);
        AuthorizationManager.getAuthorizationHandler().removeResource(resource);
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean createUpdateJob(RequestContext ctx, boolean create) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        JobBean bean = new JobBean();
        try {
            JSONObject json = JSONUtils.parse((Reader)ctx.getRequest().getReader());
            bean.restore(json);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Can't read request content", (Throwable)e);
        }
        String username = ctx.getUserName();
        List jobs = bean.getJobs();
        if (jobs.size() != 1) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Expected one job but got " + jobs.size());
        }
        MJob postedJob = (MJob)jobs.get(0);
        if (create) {
            AuthorizationEngine.createJob((String)String.valueOf(postedJob.getFromLinkId()), (String)String.valueOf(postedJob.getToLinkId()));
        } else {
            AuthorizationEngine.updateJob((String)String.valueOf(postedJob.getFromLinkId()), (String)String.valueOf(postedJob.getToLinkId()), (String)String.valueOf(postedJob.getPersistenceId()));
        }
        MFromConfig fromConfig = ConnectorManager.getInstance().getConnectorConfigurable(postedJob.getFromConnectorId()).getFromConfig();
        MToConfig toConfig = ConnectorManager.getInstance().getConnectorConfigurable(postedJob.getToConnectorId()).getToConfig();
        MDriverConfig driverConfig = Driver.getInstance().getDriver().getDriverConfig();
        if (!(fromConfig.equals((Object)postedJob.getFromJobConfig()) && driverConfig.equals((Object)postedJob.getDriverConfig()) && toConfig.equals((Object)postedJob.getToJobConfig()))) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Detected incorrect config structure");
        }
        if (!create) {
            String jobIdentifier = ctx.getLastURLElement();
            long jobId = HandlerUtils.getJobIdFromIdentifier((String)jobIdentifier, (Repository)repository);
            if (postedJob.getPersistenceId() == -1L) {
                MJob existingJob = repository.findJob(jobId);
                postedJob.setPersistenceId(existingJob.getPersistenceId());
            }
        }
        SqoopConnector fromConnector = ConnectorManager.getInstance().getSqoopConnector(postedJob.getFromConnectorId());
        SqoopConnector toConnector = ConnectorManager.getInstance().getSqoopConnector(postedJob.getToConnectorId());
        if (!fromConnector.getSupportedDirections().contains(Direction.FROM)) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0004, "Connector " + fromConnector.getClass().getCanonicalName() + " does not support FROM direction.");
        }
        if (!toConnector.getSupportedDirections().contains(Direction.TO)) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0004, "Connector " + toConnector.getClass().getCanonicalName() + " does not support TO direction.");
        }
        ConfigValidationResult fromConfigValidator = ConfigUtils.validateConfigs((List)postedJob.getFromJobConfig().getConfigs(), (Class)fromConnector.getJobConfigurationClass(Direction.FROM));
        ConfigValidationResult toConfigValidator = ConfigUtils.validateConfigs((List)postedJob.getToJobConfig().getConfigs(), (Class)toConnector.getJobConfigurationClass(Direction.TO));
        ConfigValidationResult driverConfigValidator = ConfigUtils.validateConfigs((List)postedJob.getDriverConfig().getConfigs(), (Class)Driver.getInstance().getDriverJobConfigurationClass());
        Status finalStatus = Status.getWorstStatus((Status[])new Status[]{fromConfigValidator.getStatus(), toConfigValidator.getStatus(), driverConfigValidator.getStatus()});
        ValidationResultBean validationResultBean = new ValidationResultBean(new ConfigValidationResult[]{fromConfigValidator, toConfigValidator, driverConfigValidator});
        if (finalStatus.canProceed()) {
            if (create) {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "create", "job", String.valueOf(postedJob.getPersistenceId()));
                postedJob.setCreationUser(username);
                postedJob.setLastUpdateUser(username);
                repository.createJob(postedJob);
                validationResultBean.setId(Long.valueOf(postedJob.getPersistenceId()));
            } else {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "update", "job", String.valueOf(postedJob.getPersistenceId()));
                postedJob.setLastUpdateUser(username);
                repository.updateJob(postedJob);
            }
        }
        return validationResultBean;
    }

    private JsonBean getJobs(RequestContext ctx) {
        JobsBean jobBean;
        String connectorIdentifier = ctx.getLastURLElement();
        Locale locale = ctx.getAcceptLanguageHeader();
        Repository repository = RepositoryManager.getInstance().getRepository();
        if (ctx.getParameterValue("cname") != null) {
            connectorIdentifier = ctx.getParameterValue("cname");
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "jobsByConnector", connectorIdentifier);
            long connectorId = HandlerUtils.getConnectorIdFromIdentifier((String)connectorIdentifier);
            List jobList = repository.findJobsForConnector(connectorId);
            jobList = AuthorizationEngine.filterResource((MResource.TYPE)MResource.TYPE.JOB, (List)jobList);
            jobBean = this.createJobsBean(jobList, locale);
        } else if (ctx.getPath().contains("jobs") || ctx.getPath().contains("job") && connectorIdentifier.equals("all")) {
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "jobs", "all");
            List jobList = repository.findJobs();
            jobList = AuthorizationEngine.filterResource((MResource.TYPE)MResource.TYPE.JOB, (List)jobList);
            jobBean = this.createJobsBean(jobList, locale);
        } else {
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "job", connectorIdentifier);
            long jobId = HandlerUtils.getJobIdFromIdentifier((String)connectorIdentifier, (Repository)repository);
            MJob job = repository.findJob(jobId);
            AuthorizationEngine.readJob((String)String.valueOf(job.getPersistenceId()));
            jobBean = this.createJobBean(Arrays.asList(job), locale);
        }
        return jobBean;
    }

    private JobBean createJobBean(List<MJob> jobs, Locale locale) {
        JobBean jobBean = new JobBean(jobs);
        this.addJob(jobs, locale, jobBean);
        return jobBean;
    }

    private JobsBean createJobsBean(List<MJob> jobs, Locale locale) {
        JobsBean jobsBean = new JobsBean(jobs);
        this.addJob(jobs, locale, (JobBean)jobsBean);
        return jobsBean;
    }

    private void addJob(List<MJob> jobs, Locale locale, JobBean bean) {
        for (MJob job : jobs) {
            long fromConnectorId = job.getFromConnectorId();
            long toConnectorId = job.getToConnectorId();
            if (!bean.hasConnectorConfigBundle(Long.valueOf(fromConnectorId))) {
                bean.addConnectorConfigBundle(Long.valueOf(fromConnectorId), ConnectorManager.getInstance().getResourceBundle(fromConnectorId, locale));
            }
            if (bean.hasConnectorConfigBundle(Long.valueOf(toConnectorId))) continue;
            bean.addConnectorConfigBundle(Long.valueOf(toConnectorId), ConnectorManager.getInstance().getResourceBundle(toConnectorId, locale));
        }
    }

    private JsonBean enableJob(RequestContext ctx, boolean enabled) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        String[] elements = ctx.getUrlElements();
        String jobIdentifier = elements[elements.length - 2];
        long jobId = HandlerUtils.getJobIdFromIdentifier((String)jobIdentifier, (Repository)repository);
        AuthorizationEngine.enableDisableJob((String)String.valueOf(jobId));
        repository.enableJob(jobId, enabled);
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean startJob(RequestContext ctx) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        String[] elements = ctx.getUrlElements();
        String jobIdentifier = elements[elements.length - 2];
        long jobId = HandlerUtils.getJobIdFromIdentifier((String)jobIdentifier, (Repository)repository);
        AuthorizationEngine.startJob((String)String.valueOf(jobId));
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "submit", "job", String.valueOf(jobId));
        if (JobManager.getInstance().getNotificationBaseUrl() == null) {
            String url = ctx.getRequest().getRequestURL().toString();
            JobManager.getInstance().setNotificationBaseUrl(url.split("v1")[0] + "/v1/job/status/notification/");
        }
        MSubmission submission = JobManager.getInstance().start(jobId, this.prepareRequestEventContext(ctx));
        return new SubmissionBean(submission);
    }

    private JsonBean stopJob(RequestContext ctx) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        String[] elements = ctx.getUrlElements();
        String jobIdentifier = elements[elements.length - 2];
        long jobId = HandlerUtils.getJobIdFromIdentifier((String)jobIdentifier, (Repository)repository);
        AuthorizationEngine.stopJob((String)String.valueOf(jobId));
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "stop", "job", String.valueOf(jobId));
        MSubmission submission = JobManager.getInstance().stop(jobId, this.prepareRequestEventContext(ctx));
        return new SubmissionBean(submission);
    }

    private JsonBean getJobStatus(RequestContext ctx) {
        Repository repository = RepositoryManager.getInstance().getRepository();
        String[] elements = ctx.getUrlElements();
        String jobIdentifier = elements[elements.length - 2];
        long jobId = HandlerUtils.getJobIdFromIdentifier((String)jobIdentifier, (Repository)repository);
        AuthorizationEngine.statusJob((String)String.valueOf(jobId));
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "status", "job", String.valueOf(jobId));
        MSubmission submission = JobManager.getInstance().status(jobId);
        return new SubmissionBean(submission);
    }

    private HttpEventContext prepareRequestEventContext(RequestContext ctx) {
        HttpEventContext httpEventContext = new HttpEventContext();
        httpEventContext.setUsername(ctx.getUserName());
        return httpEventContext;
    }
}

