/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.server.common.ServerError;

public class HandlerUtils {
    public static long getJobIdFromIdentifier(String identifier, Repository repository) {
        long jobId;
        if (repository.findJob(identifier) != null) {
            jobId = repository.findJob(identifier).getPersistenceId();
        } else {
            try {
                jobId = Long.valueOf(identifier);
            }
            catch (NumberFormatException ex) {
                throw new SqoopException((ErrorCode)ServerError.SERVER_0005, "Invalid job: " + identifier + " requested");
            }
        }
        return jobId;
    }

    public static long getLinkIdFromIdentifier(String identifier, Repository repository) {
        long linkId;
        if (repository.findLink(identifier) != null) {
            linkId = repository.findLink(identifier).getPersistenceId();
        } else {
            try {
                linkId = Long.valueOf(identifier);
            }
            catch (NumberFormatException ex) {
                throw new SqoopException((ErrorCode)ServerError.SERVER_0005, "Invalid link: " + identifier + " requested");
            }
        }
        return linkId;
    }

    public static long getConnectorIdFromIdentifier(String identifier) {
        long connectorId;
        if (ConnectorManager.getInstance().getConnectorId(identifier) != null) {
            connectorId = ConnectorManager.getInstance().getConnectorId(identifier);
        } else {
            try {
                connectorId = Long.valueOf(identifier);
            }
            catch (NumberFormatException ex) {
                throw new SqoopException((ErrorCode)ServerError.SERVER_0005, "Invalid connector: " + identifier + " requested");
            }
        }
        return connectorId;
    }
}

