/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.driver.Driver;
import org.apache.sqoop.json.DriverBean;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;

public class DriverRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(DriverRequestHandler.class);

    public DriverRequestHandler() {
        LOG.info((Object)"DriverRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        if (ctx.getMethod() != RequestContext.Method.GET) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0002, "Unsupported HTTP method for driver:" + ctx.getMethod());
        }
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "driver", "");
        return new DriverBean(Driver.getInstance().getDriver(), Driver.getInstance().getBundle(ctx.getAcceptLanguageHeader()));
    }
}

