/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.handler.HandlerUtils;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.ConnectorsBean;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.security.authorization.AuthorizationEngine;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;

public class ConnectorRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(ConnectorRequestHandler.class);
    private static final String CONNECTORS_PATH = "connectors";

    public ConnectorRequestHandler() {
        LOG.info((Object)"ConnectorRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        if (ctx.getMethod() != RequestContext.Method.GET) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0002, "Unsupported HTTP method for connector:" + ctx.getMethod());
        }
        Locale locale = ctx.getAcceptLanguageHeader();
        String cIdentifier = ctx.getLastURLElement();
        LOG.info((Object)("ConnectorRequestHandler handles cid: " + cIdentifier));
        if (ctx.getPath().contains(CONNECTORS_PATH) || cIdentifier.equals("all")) {
            List connectors = ConnectorManager.getInstance().getConnectorConfigurables();
            Map configParamBundles = ConnectorManager.getInstance().getResourceBundles(locale);
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", CONNECTORS_PATH, "all");
            connectors = AuthorizationEngine.filterResource((MResource.TYPE)MResource.TYPE.CONNECTOR, (List)connectors);
            return new ConnectorsBean(connectors, configParamBundles);
        }
        long cId = HandlerUtils.getConnectorIdFromIdentifier((String)cIdentifier);
        HashMap<Long, ResourceBundle> configParamBundles = new HashMap<Long, ResourceBundle>();
        MConnector connector = ConnectorManager.getInstance().getConnectorConfigurable(cId);
        configParamBundles.put(cId, ConnectorManager.getInstance().getResourceBundle(cId, locale));
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "connector", String.valueOf(cIdentifier));
        AuthorizationEngine.readConnector((String)String.valueOf(connector.getPersistenceId()));
        return new ConnectorBean(Arrays.asList(connector), configParamBundles);
    }
}

