/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.handler.AuthorizationRequestHandler;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.PrincipalsBean;
import org.apache.sqoop.json.PrivilegesBean;
import org.apache.sqoop.json.RoleBean;
import org.apache.sqoop.json.RolesBean;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;
import org.apache.sqoop.security.AuthorizationHandler;
import org.apache.sqoop.security.AuthorizationManager;
import org.apache.sqoop.security.SecurityError;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthorizationRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(AuthorizationRequestHandler.class);

    public AuthorizationRequestHandler() {
        LOG.info((Object)"AuthorizationRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        Action action = Action.fromString((String)ctx.getLastURLElement());
        String url = ctx.getRequest().getRequestURI();
        switch (1.$SwitchMap$org$apache$sqoop$server$RequestContext$Method[ctx.getMethod().ordinal()]) {
            case 1: {
                switch (1.$SwitchMap$org$apache$sqoop$handler$AuthorizationRequestHandler$Action[action.ordinal()]) {
                    case 1: {
                        return this.getRoles(ctx);
                    }
                    case 2: {
                        return this.getPrincipal(ctx);
                    }
                    case 3: {
                        return this.getPrivilege(ctx);
                    }
                }
                throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Invalid action in url" + url);
            }
            case 2: {
                switch (1.$SwitchMap$org$apache$sqoop$handler$AuthorizationRequestHandler$Action[action.ordinal()]) {
                    case 4: {
                        return this.createRole(ctx);
                    }
                }
                throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Invalid action in url" + url);
            }
            case 3: {
                String[] urlElements = ctx.getUrlElements();
                Action first_level_action = Action.fromString((String)urlElements[urlElements.length - 2]);
                switch (1.$SwitchMap$org$apache$sqoop$handler$AuthorizationRequestHandler$Action[first_level_action.ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$apache$sqoop$handler$AuthorizationRequestHandler$Action[action.ordinal()]) {
                            case 5: {
                                return this.grantRevokeRole(ctx, true);
                            }
                            case 6: {
                                return this.grantRevokeRole(ctx, false);
                            }
                        }
                        throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Invalid action in url" + url);
                    }
                    case 3: {
                        switch (1.$SwitchMap$org$apache$sqoop$handler$AuthorizationRequestHandler$Action[action.ordinal()]) {
                            case 5: {
                                return this.grantRevokePrivilege(ctx, true);
                            }
                            case 6: {
                                return this.grantRevokePrivilege(ctx, false);
                            }
                        }
                        throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Invalid action in url" + url);
                    }
                }
                throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Invalid action in url" + url);
            }
            case 4: {
                return this.dropRole(ctx);
            }
        }
        throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Invalid action in url" + url);
    }

    private JsonBean getRoles(RequestContext ctx) {
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        AuditLoggerManager manager = AuditLoggerManager.getInstance();
        String principal_name = ctx.getParameterValue("principal_name");
        String principal_type = ctx.getParameterValue("principal_type");
        if (principal_name != null && principal_type != null) {
            MPrincipal principal = new MPrincipal(principal_name, principal_type);
            manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "roles by principal", principal.toString());
            return new RolesBean(handler.getRolesByPrincipal(principal));
        }
        manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "roles", "all");
        return new RolesBean(handler.getAllRoles());
    }

    private JsonBean getPrincipal(RequestContext ctx) {
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        AuditLoggerManager manager = AuditLoggerManager.getInstance();
        String role_name = ctx.getParameterValue("role_name");
        if (role_name != null) {
            MRole role = new MRole(role_name);
            manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "principals by role", role.toString());
            return new PrincipalsBean(handler.getPrincipalsByRole(role));
        }
        throw new SqoopException((ErrorCode)SecurityError.AUTH_0012, "Can't get role name");
    }

    private JsonBean getPrivilege(RequestContext ctx) {
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        AuditLoggerManager manager = AuditLoggerManager.getInstance();
        String principal_name = ctx.getParameterValue("principal_name");
        String principal_type = ctx.getParameterValue("principal_type");
        String resource_name = ctx.getParameterValue("resource_name");
        String resource_type = ctx.getParameterValue("resource_type");
        if (principal_name != null && principal_type != null) {
            MPrincipal principal = new MPrincipal(principal_name, principal_type);
            MResource resource = null;
            if (resource_name != null && resource_type != null) {
                resource = new MResource(resource_name, resource_type);
            }
            manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "privileges by principal", principal.toString());
            return new PrivilegesBean(handler.getPrivilegesByPrincipal(principal, resource));
        }
        throw new SqoopException((ErrorCode)SecurityError.AUTH_0013, "Can't get principal");
    }

    private JsonBean createRole(RequestContext ctx) {
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        AuditLoggerManager manager = AuditLoggerManager.getInstance();
        RoleBean bean = new RoleBean();
        try {
            JSONObject json = JSONUtils.parse((Reader)ctx.getRequest().getReader());
            bean.restore(json);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Can't read request content", (Throwable)e);
        }
        List roles = bean.getRoles();
        if (roles.size() != 1) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Expected one role but got " + roles.size());
        }
        MRole postedRole = (MRole)roles.get(0);
        manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "create", "role", postedRole.toString());
        handler.createRole(postedRole);
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean grantRevokeRole(RequestContext ctx, boolean isGrant) {
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        AuditLoggerManager manager = AuditLoggerManager.getInstance();
        RolesBean rolesBean = new RolesBean();
        PrincipalsBean principalsBean = new PrincipalsBean();
        try {
            JSONObject json = JSONUtils.parse((Reader)ctx.getRequest().getReader());
            rolesBean.restore(json);
            principalsBean.restore(json);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Can't read request content", (Throwable)e);
        }
        List roles = rolesBean.getRoles();
        List principals = principalsBean.getPrincipals();
        if (isGrant) {
            manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "grant", "role", "principal");
            handler.grantRole(principals, roles);
        } else {
            manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "revoke", "role", "principal");
            handler.revokeRole(principals, roles);
        }
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean grantRevokePrivilege(RequestContext ctx, boolean isGrant) {
        List privileges;
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        AuditLoggerManager manager = AuditLoggerManager.getInstance();
        PrincipalsBean principalsBean = new PrincipalsBean();
        PrivilegesBean privilegesBean = new PrivilegesBean();
        try {
            JSONObject json = JSONUtils.parse((Reader)ctx.getRequest().getReader());
            principalsBean.restore(json);
            try {
                privilegesBean.restore(json);
            }
            catch (Exception e) {
                privilegesBean = null;
            }
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Can't read request content", (Throwable)e);
        }
        List principals = principalsBean.getPrincipals();
        List list = privileges = privilegesBean == null ? null : privilegesBean.getPrivileges();
        if (isGrant) {
            manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "grant", "role", "privilege");
            handler.grantPrivileges(principals, privileges);
        } else {
            manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "revoke", "role", "privilege");
            handler.revokePrivileges(principals, privileges);
        }
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean dropRole(RequestContext ctx) {
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        AuditLoggerManager manager = AuditLoggerManager.getInstance();
        String[] urlElements = ctx.getUrlElements();
        if (urlElements.length < 2 || !urlElements[urlElements.length - 2].equals(Action.ROLES.name)) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0012, "Can't get role name");
        }
        String role_name = ctx.getLastURLElement();
        MRole role = new MRole(role_name);
        manager.logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "delete", "role", role.toString());
        handler.dropRole(role);
        return JsonBean.EMPTY_BEAN;
    }
}

