/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.filter;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticationHandler;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.security.SecurityConstants;
import org.apache.sqoop.security.SecurityError;

public class SqoopAuthenticationFilter
extends DelegationTokenAuthenticationFilter {
    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties properties = new Properties();
        MapContext mapContext = SqoopConfiguration.getInstance().getContext();
        String type = mapContext.getString("org.apache.sqoop.security.authentication.type", SecurityConstants.TYPE.SIMPLE.name()).trim();
        if (type.equalsIgnoreCase(SecurityConstants.TYPE.KERBEROS.name())) {
            properties.setProperty("type", KerberosDelegationTokenAuthenticationHandler.class.getName());
            String keytab = mapContext.getString("org.apache.sqoop.security.authentication.kerberos.http.keytab").trim();
            if (keytab.length() == 0) {
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0005, "org.apache.sqoop.security.authentication.kerberos.http.keytab");
            }
            String principal = mapContext.getString("org.apache.sqoop.security.authentication.kerberos.http.principal").trim();
            if (principal.length() == 0) {
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0006, "org.apache.sqoop.security.authentication.kerberos.http.principal");
            }
            String hostPrincipal = "";
            try {
                hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
            }
            catch (IOException e) {
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0006, "org.apache.sqoop.security.authentication.kerberos.http.principal");
            }
            properties.setProperty("kerberos.principal", hostPrincipal);
            properties.setProperty("kerberos.keytab", keytab);
        } else if (type.equalsIgnoreCase(SecurityConstants.TYPE.CUSTOM.name())) {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "custom");
            UserGroupInformation.setConfiguration((Configuration)conf);
            properties.setProperty("type", mapContext.getString("org.apache.sqoop.security.authentication.custom_handler").trim());
            this.setHandlerAuthMethod(SaslRpcServer.AuthMethod.TOKEN);
        } else if (type.equalsIgnoreCase(SecurityConstants.TYPE.SIMPLE.name())) {
            properties.setProperty("type", PseudoDelegationTokenAuthenticationHandler.class.getName());
            properties.setProperty("simple.anonymous.allowed", mapContext.getString("org.apache.sqoop.security.authentication.anonymous", "true").trim());
        } else {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0004, type);
        }
        properties.setProperty("delegation-token.token-kind", "sqoop_token_kind");
        return properties;
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) {
        MapContext mapContext = SqoopConfiguration.getInstance().getContext();
        Map proxyuserConf = mapContext.getValByRegex("org\\.apache\\.sqoop\\.authentication\\.proxyuser");
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : proxyuserConf.entrySet()) {
            conf.set(((String)entry.getKey()).substring("org.apache.sqoop.authentication.proxyuser.".length()), (String)entry.getValue());
        }
        return conf;
    }
}

