/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.framework.JobManager;
import org.apache.sqoop.handler.SubmissionRequestHandler;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.SubmissionBean;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.request.HttpEventContext;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;

public class SubmissionRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(SubmissionRequestHandler.class);

    public SubmissionRequestHandler() {
        LOG.info((Object)"SubmissionRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        String[] urlElements = ctx.getUrlElements();
        if (urlElements.length < 2) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Invalid URL, too few arguments for this servlet.");
        }
        int length = urlElements.length;
        String action = urlElements[length - 2];
        if (action.equals("action")) {
            return this.handleActionEvent(ctx, urlElements[length - 1]);
        }
        if (action.equals("notification")) {
            return this.handleNotification(ctx, urlElements[length - 1]);
        }
        if (action.equals("history")) {
            return this.handleHistoryEvent(ctx, urlElements[length - 1]);
        }
        throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Do not know what to do.");
    }

    private JsonBean handleNotification(RequestContext ctx, String sjid) {
        LOG.debug((Object)("Received notification request for job " + sjid));
        JobManager.getInstance().status(Long.parseLong(sjid));
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean handleActionEvent(RequestContext ctx, String sjid) {
        long jid = Long.parseLong(sjid);
        String username = ctx.getUserName();
        HttpEventContext ectx = new HttpEventContext();
        ectx.setUsername(username);
        switch (1.$SwitchMap$org$apache$sqoop$server$RequestContext$Method[ctx.getMethod().ordinal()]) {
            case 1: {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "status", "submission", String.valueOf(jid));
                return this.submissionStatus(jid);
            }
            case 2: {
                if (JobManager.getInstance().getNotificationBaseUrl() == null) {
                    String url = ctx.getRequest().getRequestURL().toString();
                    JobManager.getInstance().setNotificationBaseUrl(url.split("v1")[0] + "/v1/submission/notification/");
                }
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "submit", "submission", String.valueOf(jid));
                return this.submissionSubmit(jid, ectx);
            }
            case 3: {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "stop", "submission", String.valueOf(jid));
                return this.submissionStop(jid, ectx);
            }
        }
        return null;
    }

    private JsonBean handleHistoryEvent(RequestContext ctx, String sjid) {
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "submission", sjid);
        if (sjid.equals("all")) {
            return this.getSubmissions();
        }
        return this.getSubmissionsForJob(Long.parseLong(sjid));
    }

    private JsonBean submissionStop(long jid, HttpEventContext ctx) {
        MSubmission submission = JobManager.getInstance().stop(jid, ctx);
        return new SubmissionBean(submission);
    }

    private JsonBean submissionSubmit(long jid, HttpEventContext ctx) {
        MSubmission submission = JobManager.getInstance().submit(jid, ctx);
        return new SubmissionBean(submission);
    }

    private JsonBean submissionStatus(long jid) {
        MSubmission submission = JobManager.getInstance().status(jid);
        return new SubmissionBean(submission);
    }

    private JsonBean getSubmissions() {
        List submissions = RepositoryManager.getInstance().getRepository().findSubmissions();
        return new SubmissionBean(submissions);
    }

    private JsonBean getSubmissionsForJob(long jid) {
        List submissions = RepositoryManager.getInstance().getRepository().findSubmissionsForJob(jid);
        return new SubmissionBean(submissions);
    }
}

