/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.framework.FrameworkManager;
import org.apache.sqoop.handler.JobRequestHandler;
import org.apache.sqoop.json.JobBean;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.ValidationBean;
import org.apache.sqoop.model.FormUtils;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;
import org.apache.sqoop.utils.ClassUtils;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;
import org.apache.sqoop.validation.Validator;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JobRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(JobRequestHandler.class);
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";

    public JobRequestHandler() {
        LOG.info((Object)"JobRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        switch (1.$SwitchMap$org$apache$sqoop$server$RequestContext$Method[ctx.getMethod().ordinal()]) {
            case 1: {
                return this.getJobs(ctx);
            }
            case 2: {
                return this.createUpdateJob(ctx, false);
            }
            case 3: {
                if (ctx.getLastURLElement().equals(ENABLE)) {
                    return this.enableJob(ctx, true);
                }
                if (ctx.getLastURLElement().equals(DISABLE)) {
                    return this.enableJob(ctx, false);
                }
                return this.createUpdateJob(ctx, true);
            }
            case 4: {
                return this.deleteJob(ctx);
            }
        }
        return null;
    }

    private JsonBean deleteJob(RequestContext ctx) {
        String sxid = ctx.getLastURLElement();
        long jid = Long.valueOf(sxid);
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "delete", "job", sxid);
        Repository repository = RepositoryManager.getInstance().getRepository();
        repository.deleteJob(jid);
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean createUpdateJob(RequestContext ctx, boolean update) {
        String username = ctx.getUserName();
        JobBean bean = new JobBean();
        try {
            JSONObject json = (JSONObject)JSONValue.parse((Reader)ctx.getRequest().getReader());
            bean.restore(json);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Can't read request content", (Throwable)e);
        }
        List jobs = bean.getJobs();
        if (jobs.size() != 1) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Expected one job metadata but got " + jobs.size());
        }
        MJob job = (MJob)jobs.get(0);
        MJobForms connectorForms = ConnectorManager.getInstance().getConnectorMetadata(job.getConnectorId()).getJobForms(job.getType());
        MJobForms frameworkForms = FrameworkManager.getInstance().getFramework().getJobForms(job.getType());
        if (!connectorForms.equals((Object)job.getConnectorPart()) || !frameworkForms.equals((Object)job.getFrameworkPart())) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Detected incorrect form structure");
        }
        SqoopConnector connector = ConnectorManager.getInstance().getConnector(job.getConnectorId());
        Validator connectorValidator = connector.getValidator();
        Validator frameworkValidator = FrameworkManager.getInstance().getValidator();
        Object connectorConfig = ClassUtils.instantiate((Class)connector.getJobConfigurationClass(job.getType()), (Object[])new Object[0]);
        Object frameworkConfig = ClassUtils.instantiate((Class)FrameworkManager.getInstance().getJobConfigurationClass(job.getType()), (Object[])new Object[0]);
        FormUtils.fromForms((List)job.getConnectorPart().getForms(), (Object)connectorConfig);
        FormUtils.fromForms((List)job.getFrameworkPart().getForms(), (Object)frameworkConfig);
        Validation connectorValidation = connectorValidator.validateJob(job.getType(), connectorConfig);
        Validation frameworkValidation = frameworkValidator.validateJob(job.getType(), frameworkConfig);
        Status finalStatus = Status.getWorstStatus((Status[])new Status[]{connectorValidation.getStatus(), frameworkValidation.getStatus()});
        ValidationBean outputBean = new ValidationBean(connectorValidation, frameworkValidation);
        if (finalStatus.canProceed()) {
            if (update) {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "update", "job", String.valueOf(job.getPersistenceId()));
                job.setLastUpdateUser(username);
                RepositoryManager.getInstance().getRepository().updateJob(job);
            } else {
                job.setCreationUser(username);
                job.setLastUpdateUser(username);
                RepositoryManager.getInstance().getRepository().createJob(job);
                outputBean.setId(Long.valueOf(job.getPersistenceId()));
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "create", "job", String.valueOf(job.getPersistenceId()));
            }
        }
        return outputBean;
    }

    private JsonBean getJobs(RequestContext ctx) {
        JobBean bean;
        String sjid = ctx.getLastURLElement();
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "job", sjid);
        Locale locale = ctx.getAcceptLanguageHeader();
        Repository repository = RepositoryManager.getInstance().getRepository();
        if (sjid.equals("all")) {
            List jobs = repository.findJobs();
            bean = new JobBean(jobs);
            for (MJob job : jobs) {
                long connectorId = job.getConnectorId();
                if (bean.hasConnectorBundle(Long.valueOf(connectorId))) continue;
                bean.addConnectorBundle(Long.valueOf(connectorId), ConnectorManager.getInstance().getResourceBundle(connectorId, locale));
            }
        } else {
            long jid = Long.valueOf(sjid);
            MJob job = repository.findJob(jid);
            long connectorId = job.getConnectorId();
            bean = new JobBean(job);
            bean.addConnectorBundle(Long.valueOf(connectorId), ConnectorManager.getInstance().getResourceBundle(connectorId, locale));
        }
        bean.setFrameworkBundle(FrameworkManager.getInstance().getBundle(locale));
        return bean;
    }

    private JsonBean enableJob(RequestContext ctx, boolean enabled) {
        String[] elements = ctx.getUrlElements();
        String sjid = elements[elements.length - 2];
        long xid = Long.valueOf(sjid);
        Repository repository = RepositoryManager.getInstance().getRepository();
        repository.enableJob(xid, enabled);
        return JsonBean.EMPTY_BEAN;
    }
}

