/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.json.ConnectorBean;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;

public class ConnectorRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(ConnectorRequestHandler.class);

    public ConnectorRequestHandler() {
        LOG.info((Object)"ConnectorRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        HashMap<Long, ResourceBundle> bundles;
        LinkedList<MConnector> connectors;
        Locale locale = ctx.getAcceptLanguageHeader();
        String cid = ctx.getLastURLElement();
        LOG.info((Object)("ConnectorRequestHandler handles cid: " + cid));
        if (cid.equals("all")) {
            connectors = ConnectorManager.getInstance().getConnectorsMetadata();
            bundles = ConnectorManager.getInstance().getResourceBundles(locale);
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "connector", "all");
        } else {
            Long id = Long.parseLong(cid);
            if (!ConnectorManager.getInstance().getConnectorIds().contains(id)) {
                throw new SqoopException((ErrorCode)ServerError.SERVER_0004, "Invalid id " + id);
            }
            connectors = new LinkedList<MConnector>();
            bundles = new HashMap<Long, ResourceBundle>();
            connectors.add(ConnectorManager.getInstance().getConnectorMetadata(id.longValue()));
            bundles.put(id, ConnectorManager.getInstance().getResourceBundle(id.longValue(), locale));
            AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "connector", String.valueOf(id));
        }
        return new ConnectorBean(connectors, bundles);
    }
}

