/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.sqoop.audit.AuditLoggerManager;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.framework.FrameworkManager;
import org.apache.sqoop.handler.ConnectionRequestHandler;
import org.apache.sqoop.json.ConnectionBean;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.ValidationBean;
import org.apache.sqoop.model.FormUtils;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.server.RequestContext;
import org.apache.sqoop.server.RequestHandler;
import org.apache.sqoop.server.common.ServerError;
import org.apache.sqoop.utils.ClassUtils;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;
import org.apache.sqoop.validation.Validator;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ConnectionRequestHandler
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(ConnectionRequestHandler.class);
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";

    public ConnectionRequestHandler() {
        LOG.info((Object)"ConnectionRequestHandler initialized");
    }

    public JsonBean handleEvent(RequestContext ctx) {
        switch (1.$SwitchMap$org$apache$sqoop$server$RequestContext$Method[ctx.getMethod().ordinal()]) {
            case 1: {
                return this.getConnections(ctx);
            }
            case 2: {
                return this.createUpdateConnection(ctx, false);
            }
            case 3: {
                if (ctx.getLastURLElement().equals(ENABLE)) {
                    return this.enableConnection(ctx, true);
                }
                if (ctx.getLastURLElement().equals(DISABLE)) {
                    return this.enableConnection(ctx, false);
                }
                return this.createUpdateConnection(ctx, true);
            }
            case 4: {
                return this.deleteConnection(ctx);
            }
        }
        return null;
    }

    private JsonBean deleteConnection(RequestContext ctx) {
        String sxid = ctx.getLastURLElement();
        long xid = Long.valueOf(sxid);
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "delete", "connection", sxid);
        Repository repository = RepositoryManager.getInstance().getRepository();
        repository.deleteConnection(xid);
        return JsonBean.EMPTY_BEAN;
    }

    private JsonBean createUpdateConnection(RequestContext ctx, boolean update) {
        String username = ctx.getUserName();
        ConnectionBean bean = new ConnectionBean();
        try {
            JSONObject json = (JSONObject)JSONValue.parse((Reader)ctx.getRequest().getReader());
            bean.restore(json);
        }
        catch (IOException e) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Can't read request content", (Throwable)e);
        }
        List connections = bean.getConnections();
        if (connections.size() != 1) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Expected one connection metadata but got " + connections.size());
        }
        MConnection connection = (MConnection)connections.get(0);
        MConnectionForms connectorForms = ConnectorManager.getInstance().getConnectorMetadata(connection.getConnectorId()).getConnectionForms();
        MConnectionForms frameworkForms = FrameworkManager.getInstance().getFramework().getConnectionForms();
        if (!connectorForms.equals((Object)connection.getConnectorPart()) || !frameworkForms.equals((Object)connection.getFrameworkPart())) {
            throw new SqoopException((ErrorCode)ServerError.SERVER_0003, "Detected incorrect form structure");
        }
        SqoopConnector connector = ConnectorManager.getInstance().getConnector(connection.getConnectorId());
        Validator connectorValidator = connector.getValidator();
        Validator frameworkValidator = FrameworkManager.getInstance().getValidator();
        Object connectorConfig = ClassUtils.instantiate((Class)connector.getConnectionConfigurationClass(), (Object[])new Object[0]);
        Object frameworkConfig = ClassUtils.instantiate((Class)FrameworkManager.getInstance().getConnectionConfigurationClass(), (Object[])new Object[0]);
        FormUtils.fromForms((List)connection.getConnectorPart().getForms(), (Object)connectorConfig);
        FormUtils.fromForms((List)connection.getFrameworkPart().getForms(), (Object)frameworkConfig);
        Validation connectorValidation = connectorValidator.validateConnection(connectorConfig);
        Validation frameworkValidation = frameworkValidator.validateConnection(frameworkConfig);
        Status finalStatus = Status.getWorstStatus((Status[])new Status[]{connectorValidation.getStatus(), frameworkValidation.getStatus()});
        ValidationBean outputBean = new ValidationBean(connectorValidation, frameworkValidation);
        if (finalStatus.canProceed()) {
            if (update) {
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "update", "connection", String.valueOf(connection.getPersistenceId()));
                connection.setLastUpdateUser(username);
                RepositoryManager.getInstance().getRepository().updateConnection(connection);
            } else {
                connection.setCreationUser(username);
                connection.setLastUpdateUser(username);
                RepositoryManager.getInstance().getRepository().createConnection(connection);
                outputBean.setId(Long.valueOf(connection.getPersistenceId()));
                AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "create", "connection", String.valueOf(connection.getPersistenceId()));
            }
        }
        return outputBean;
    }

    private JsonBean getConnections(RequestContext ctx) {
        ConnectionBean bean;
        String sxid = ctx.getLastURLElement();
        AuditLoggerManager.getInstance().logAuditEvent(ctx.getUserName(), ctx.getRequest().getRemoteAddr(), "get", "connection", sxid);
        Locale locale = ctx.getAcceptLanguageHeader();
        Repository repository = RepositoryManager.getInstance().getRepository();
        if (sxid.equals("all")) {
            List connections = repository.findConnections();
            bean = new ConnectionBean(connections);
            for (MConnection connection : connections) {
                long connectorId = connection.getConnectorId();
                if (bean.hasConnectorBundle(Long.valueOf(connectorId))) continue;
                bean.addConnectorBundle(Long.valueOf(connectorId), ConnectorManager.getInstance().getResourceBundle(connectorId, locale));
            }
        } else {
            long xid = Long.valueOf(sxid);
            MConnection connection = repository.findConnection(xid);
            long connectorId = connection.getConnectorId();
            bean = new ConnectionBean(connection);
            bean.addConnectorBundle(Long.valueOf(connectorId), ConnectorManager.getInstance().getResourceBundle(connectorId, locale));
        }
        bean.setFrameworkBundle(FrameworkManager.getInstance().getBundle(locale));
        return bean;
    }

    private JsonBean enableConnection(RequestContext ctx, boolean enabled) {
        String[] elements = ctx.getUrlElements();
        String sxid = elements[elements.length - 2];
        long xid = Long.valueOf(sxid);
        Repository repository = RepositoryManager.getInstance().getRepository();
        repository.enableConnection(xid, enabled);
        return JsonBean.EMPTY_BEAN;
    }
}

