/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.security.authorization;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MRole;
import org.apache.sqoop.security.AuthenticationProvider;
import org.apache.sqoop.security.AuthorizationAccessController;
import org.apache.sqoop.security.AuthorizationHandler;
import org.apache.sqoop.security.AuthorizationValidator;
import org.apache.sqoop.security.SecurityFactory;

public class DefaultAuthorizationHandler
extends AuthorizationHandler {
    public static final String DEFAULT_AUTHORIZATION_ACCESS_CONTROLLER = "org.apache.sqoop.security.authorization.DefaultAuthorizationAccessController";
    public static final String DEFAULT_AUTHORIZATION_VALIDATOR = "org.apache.sqoop.security.authorization.DefaultAuthorizationValidator";
    private static final Logger LOG = Logger.getLogger(DefaultAuthorizationHandler.class);
    protected AuthorizationAccessController authorizationAccessController;
    protected AuthorizationValidator authorizationValidator;
    protected AuthenticationProvider authenticationProvider;
    protected String serverName;

    public AuthorizationValidator getAuthorizationValidator() {
        return this.authorizationValidator;
    }

    public void setAuthorizationValidator(AuthorizationValidator authorizationValidator) {
        this.authorizationValidator = authorizationValidator;
    }

    public AuthorizationAccessController getAuthorizationAccessController() {
        return this.authorizationAccessController;
    }

    public void setAuthorizationAccessController(AuthorizationAccessController authorizationAccessController) {
        this.authorizationAccessController = authorizationAccessController;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public void doInitialize(AuthenticationProvider provider, String serverName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        MapContext mapContext = SqoopConfiguration.getInstance().getContext();
        String accessController = mapContext.getString("org.apache.sqoop.security.authorization.access_controller", DEFAULT_AUTHORIZATION_ACCESS_CONTROLLER).trim();
        this.authorizationAccessController = SecurityFactory.getAuthorizationAccessController((String)accessController);
        String validator = mapContext.getString("org.apache.sqoop.security.authorization.validator", DEFAULT_AUTHORIZATION_VALIDATOR).trim();
        this.authorizationValidator = SecurityFactory.getAuthorizationValidator((String)validator);
        this.authenticationProvider = provider;
        this.serverName = serverName;
    }

    public void createRole(MRole role) throws SqoopException {
        this.authorizationAccessController.createRole(role);
    }

    public void dropRole(MRole role) throws SqoopException {
        this.authorizationAccessController.dropRole(role);
    }

    public List<MRole> getAllRoles() throws SqoopException {
        return this.authorizationAccessController.getAllRoles();
    }

    public List<MRole> getRolesByPrincipal(MPrincipal principal) throws SqoopException {
        return this.authorizationAccessController.getRolesByPrincipal(principal);
    }

    public List<MPrincipal> getPrincipalsByRole(MRole role) throws SqoopException {
        return this.authorizationAccessController.getPrincipalsByRole(role);
    }

    public void grantRole(List<MPrincipal> principals, List<MRole> roles) throws SqoopException {
        this.authorizationAccessController.grantRole(principals, roles);
    }

    public void revokeRole(List<MPrincipal> principals, List<MRole> roles) throws SqoopException {
        this.authorizationAccessController.revokeRole(principals, roles);
    }

    public void updateResource(MResource old_resource, MResource new_resource) throws SqoopException {
        this.authorizationAccessController.updateResource(old_resource, new_resource);
    }

    public void removeResource(MResource resource) throws SqoopException {
        this.authorizationAccessController.removeResource(resource);
    }

    public List<MPrivilege> getPrivilegesByPrincipal(MPrincipal principal, MResource resource) throws SqoopException {
        return this.authorizationAccessController.getPrivilegesByPrincipal(principal, resource);
    }

    public void grantPrivileges(List<MPrincipal> principals, List<MPrivilege> privileges) throws SqoopException {
        this.authorizationAccessController.grantPrivileges(principals, privileges);
    }

    public void revokePrivileges(List<MPrincipal> principals, List<MPrivilege> privileges) throws SqoopException {
        this.authorizationAccessController.revokePrivileges(principals, privileges);
    }

    public void checkPrivileges(MPrincipal principal, List<MPrivilege> privileges) throws SqoopException {
        this.authorizationValidator.checkPrivileges(principal, privileges);
    }
}

