/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.security.authentication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.security.AuthenticationHandler;
import org.apache.sqoop.security.SecurityConstants;
import org.apache.sqoop.security.SecurityError;

public class KerberosAuthenticationHandler
extends AuthenticationHandler {
    private static final Logger LOG = Logger.getLogger(KerberosAuthenticationHandler.class);
    private String keytabPrincipal;
    private String keytabFile;

    public String getKeytabPrincipal() {
        return this.keytabPrincipal;
    }

    public String getKeytabFile() {
        return this.keytabFile;
    }

    public void doInitialize() {
        this.securityEnabled = true;
    }

    public void secureLogin() {
        MapContext mapContext = SqoopConfiguration.getInstance().getContext();
        String keytab = mapContext.getString("org.apache.sqoop.security.authentication.kerberos.keytab").trim();
        if (keytab.length() == 0) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0001, "org.apache.sqoop.security.authentication.kerberos.keytab");
        }
        this.keytabFile = keytab;
        String principal = mapContext.getString("org.apache.sqoop.security.authentication.kerberos.principal").trim();
        if (principal.length() == 0) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0002, "org.apache.sqoop.security.authentication.kerberos.principal");
        }
        this.keytabPrincipal = principal;
        Configuration conf = new Configuration();
        conf.set(this.get_hadoop_security_authentication(), SecurityConstants.TYPE.KERBEROS.name());
        UserGroupInformation.setConfiguration((Configuration)conf);
        try {
            String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
            UserGroupInformation.loginUserFromKeytab((String)hostPrincipal, (String)keytab);
        }
        catch (IOException ex) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0003, (Throwable)ex);
        }
        LOG.info((Object)("Using Kerberos authentication, principal [" + principal + "] keytab [" + keytab + "]"));
    }
}

