/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.schema.SchemaError;
import org.apache.sqoop.schema.type.Column;

public class Schema {
    private String name;
    private String note;
    private Date creationDate = new Date();
    private List<Column> columns = new LinkedList<Column>();
    private Set<String> columNames = new HashSet<String>();

    private Schema() {
    }

    public Schema(String name) {
        this();
        assert (name != null);
        this.name = name;
    }

    public Schema addColumn(Column column) {
        if (column.getName() == null) {
            throw new SqoopException((ErrorCode)SchemaError.SCHEMA_0001, "Column: " + column);
        }
        if (this.columNames.contains(column.getName())) {
            throw new SqoopException((ErrorCode)SchemaError.SCHEMA_0002, "Column: " + column);
        }
        this.columNames.add(column.getName());
        this.columns.add(column);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getNote() {
        return this.note;
    }

    public Schema setNote(String note) {
        this.note = note;
        return this;
    }

    public Schema setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String toString() {
        return "Schema{" + "name=" + this.name + "" + ",columns=[\n\t" + StringUtils.join(this.columns, (String)",\n\t") + "]" + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)o;
        if (this.columns != null ? !this.columns.equals(schema.columns) : schema.columns != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(schema.name) : schema.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        return result;
    }
}

