/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counters;

public class MSubmission
extends MAccountableEntity {
    private long jobId;
    SubmissionStatus status = SubmissionStatus.UNKNOWN;
    String externalId;
    double progress = -1.0;
    Counters counters;
    String externalLink;
    String exceptionInfo;
    String exceptionStackTrace;
    Schema connectorSchema;
    Schema hioSchema;
    public static MSubmission UNKNOWN = new MSubmission();

    public MSubmission() {
    }

    public MSubmission(long jobId, Date creationDate, SubmissionStatus status) {
        this();
        this.jobId = jobId;
        this.status = status;
        this.setCreationDate(creationDate);
    }

    public MSubmission(long jobId) {
        this(jobId, new Date(), SubmissionStatus.BOOTING);
    }

    public MSubmission(long jobId, Date creationDate, SubmissionStatus status, String externalId) {
        this(jobId, creationDate, status);
        this.externalId = externalId;
    }

    public MSubmission(long jobId, Date creationDate, SubmissionStatus status, String externalId, String externalLink, Counters counters) {
        this(jobId, creationDate, status, externalId);
        this.externalLink = externalLink;
        this.counters = counters;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public long getJobId() {
        return this.jobId;
    }

    public void setStatus(SubmissionStatus status) {
        this.status = status;
    }

    public SubmissionStatus getStatus() {
        return this.status;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setCounters(Counters counters) {
        this.counters = counters;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setExternalLink(String externalLink) {
        this.externalLink = externalLink;
    }

    public String getExternalLink() {
        return this.externalLink;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public String getExceptionInfo() {
        return this.exceptionInfo;
    }

    public void setExceptionStackTrace(String stackTrace) {
        this.exceptionStackTrace = stackTrace;
    }

    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public void setException(Throwable e) {
        this.setExceptionInfo(e.toString());
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        writer.flush();
        this.setExceptionStackTrace(writer.toString());
    }

    public Schema getConnectorSchema() {
        return this.connectorSchema;
    }

    public void setConnectorSchema(Schema connectorSchema) {
        this.connectorSchema = connectorSchema;
    }

    public Schema getHioSchema() {
        return this.hioSchema;
    }

    public void setHioSchema(Schema hioSchema) {
        this.hioSchema = hioSchema;
    }

    @Override
    public String toString() {
        return "MSubmission{jobId=" + this.jobId + ", creationDate=" + this.getCreationDate() + ", lastUpdateDate=" + this.getLastUpdateDate() + ", status=" + (Object)((Object)this.status) + ", externalId='" + this.externalId + '\'' + ", progress=" + this.progress + ", counters=" + this.counters + ", externalLink='" + this.externalLink + '\'' + ", exceptionInfo='" + this.exceptionInfo + '\'' + ", exceptionStackTrace='" + this.exceptionStackTrace + '\'' + ", connectorSchema='" + this.connectorSchema + '\'' + ", hioSchema='" + this.hioSchema + '\'' + '}';
    }
}

