/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MJobForms;
import org.apache.sqoop.model.ModelError;

public class MJob
extends MAccountableEntity
implements MClonable {
    private final long connectorId;
    private final long connectionId;
    private String name;
    private final Type type;
    private final MJobForms connectorPart;
    private final MJobForms frameworkPart;

    public MJob(long connectorId, long connectionId, Type type, MJobForms connectorPart, MJobForms frameworkPart) {
        this.connectorId = connectorId;
        this.connectionId = connectionId;
        this.type = type;
        this.connectorPart = connectorPart;
        this.frameworkPart = frameworkPart;
        this.verifyFormsOfSameType();
    }

    public MJob(MJob other) {
        this(other, other.connectorPart.clone(true), other.frameworkPart.clone(true));
    }

    public MJob(MJob other, MJobForms connectorPart, MJobForms frameworkPart) {
        super(other);
        this.connectionId = other.connectionId;
        this.connectorId = other.connectorId;
        this.type = other.type;
        this.name = other.name;
        this.connectorPart = connectorPart;
        this.frameworkPart = frameworkPart;
        this.verifyFormsOfSameType();
    }

    private void verifyFormsOfSameType() {
        if (this.type != this.connectorPart.getType() || this.type != this.frameworkPart.getType()) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_002, "Incompatible types, job: " + this.type.name() + ", connector part: " + this.connectorPart.getType().name() + ", framework part: " + this.frameworkPart.getType().name());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("job connector-part: ");
        sb.append(this.connectorPart).append(", framework-part: ").append(this.frameworkPart);
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public long getConnectorId() {
        return this.connectorId;
    }

    public MJobForms getConnectorPart() {
        return this.connectorPart;
    }

    public MJobForms getFrameworkPart() {
        return this.frameworkPart;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public MJob clone(boolean cloneWithValue) {
        if (cloneWithValue) {
            return new MJob(this);
        }
        return new MJob(this.connectorId, this.connectionId, this.type, this.connectorPart.clone(false), this.frameworkPart.clone(false));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MJob)) {
            return false;
        }
        MJob job = (MJob)object;
        return job.connectorId == this.connectorId && job.connectionId == this.connectionId && job.getPersistenceId() == this.getPersistenceId() && job.type.equals((Object)this.type) && job.connectorPart.equals(this.connectorPart) && job.frameworkPart.equals(this.frameworkPart);
    }

    public static enum Type {
        IMPORT,
        EXPORT;

    }
}

