/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.apache.sqoop.model.MPersistableEntity;
import org.apache.sqoop.model.ModelError;

public class MFramework
extends MPersistableEntity
implements MClonable {
    private final MConnectionForms connectionForms;
    private final Map<MJob.Type, MJobForms> jobs;
    String version;

    public MFramework(MConnectionForms connectionForms, List<MJobForms> jobForms, String version) {
        this.version = version;
        this.connectionForms = connectionForms;
        this.jobs = new HashMap<MJob.Type, MJobForms>();
        for (MJobForms job : jobForms) {
            MJob.Type type = job.getType();
            if (this.jobs.containsKey((Object)type)) {
                throw new SqoopException((ErrorCode)ModelError.MODEL_001, "Duplicate entry for jobForms type " + job.getType().name());
            }
            this.jobs.put(type, job);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("framework-");
        sb.append(this.getPersistenceId()).append(":");
        sb.append("version = " + this.version);
        sb.append(", ").append(this.connectionForms.toString());
        for (MJobForms entry : this.jobs.values()) {
            sb.append(entry.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MFramework)) {
            return false;
        }
        MFramework mo = (MFramework)other;
        return this.version.equals(mo.getVersion()) && this.connectionForms.equals(mo.connectionForms) && this.jobs.equals(mo.jobs);
    }

    public int hashCode() {
        int result = this.connectionForms.hashCode();
        for (MJobForms entry : this.jobs.values()) {
            result = 31 * result + entry.hashCode();
        }
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public MConnectionForms getConnectionForms() {
        return this.connectionForms;
    }

    public Map<MJob.Type, MJobForms> getAllJobsForms() {
        return this.jobs;
    }

    public MJobForms getJobForms(MJob.Type type) {
        return this.jobs.get((Object)type);
    }

    @Override
    public MFramework clone(boolean cloneWithValue) {
        cloneWithValue = false;
        ArrayList<MJobForms> copyJobForms = null;
        if (this.getAllJobsForms() != null) {
            copyJobForms = new ArrayList<MJobForms>();
            for (MJobForms entry : this.getAllJobsForms().values()) {
                copyJobForms.add(entry.clone(cloneWithValue));
            }
        }
        MFramework copy = new MFramework(this.getConnectionForms().clone(cloneWithValue), copyJobForms, this.version);
        copy.setPersistenceId(this.getPersistenceId());
        return copy;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

