/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MValidatedElement;
import org.apache.sqoop.model.ModelError;

public final class MForm
extends MValidatedElement
implements MClonable {
    private final List<MInput<?>> inputs;

    public MForm(String name, List<MInput<?>> inputs) {
        super(name);
        this.inputs = inputs;
    }

    public List<MInput<?>> getInputs() {
        return this.inputs;
    }

    public MInput<?> getInput(String inputName) {
        for (MInput<?> input : this.inputs) {
            if (!inputName.equals(input.getName())) continue;
            return input;
        }
        throw new SqoopException((ErrorCode)ModelError.MODEL_011, "Input name: " + inputName);
    }

    public MStringInput getStringInput(String inputName) {
        return (MStringInput)this.getInput(inputName);
    }

    public MEnumInput getEnumInput(String inputName) {
        return (MEnumInput)this.getInput(inputName);
    }

    public MIntegerInput getIntegerInput(String inputName) {
        return (MIntegerInput)this.getInput(inputName);
    }

    public MBooleanInput getBooleanInput(String inputName) {
        return (MBooleanInput)this.getInput(inputName);
    }

    public MMapInput getMapInput(String inputName) {
        return (MMapInput)this.getInput(inputName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("form-").append(this.getName());
        sb.append(":").append(this.getPersistenceId()).append(":").append(this.inputs);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MForm)) {
            return false;
        }
        MForm mf = (MForm)other;
        return this.getName().equals(mf.getName()) && this.inputs.equals(mf.inputs);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getName().hashCode();
        for (MInput<?> mi : this.inputs) {
            result = 31 * result + mi.hashCode();
        }
        return result;
    }

    @Override
    public MForm clone(boolean cloneWithValue) {
        ArrayList copyInputs = new ArrayList();
        for (MInput<?> itr : this.getInputs()) {
            copyInputs.add((MInput)itr.clone(cloneWithValue));
        }
        MForm copyForm = new MForm(this.getName(), copyInputs);
        return copyForm;
    }
}

