/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MFramework;
import org.apache.sqoop.model.MJobForms;

public final class MConnector
extends MFramework {
    private final String uniqueName;
    private final String className;

    public MConnector(String uniqueName, String className, String version, MConnectionForms connectionForms, List<MJobForms> jobForms) {
        super(connectionForms, jobForms, version);
        if (uniqueName == null || className == null) {
            throw new NullPointerException();
        }
        this.uniqueName = uniqueName;
        this.className = className;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("connector-");
        sb.append(this.uniqueName).append(":").append(this.getPersistenceId()).append(":");
        sb.append(this.className);
        sb.append(", ").append(this.getConnectionForms().toString());
        for (MJobForms entry : this.getAllJobsForms().values()) {
            sb.append(entry.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MConnector)) {
            return false;
        }
        MConnector mc = (MConnector)other;
        return this.uniqueName.equals(mc.uniqueName) && this.className.equals(mc.className) && this.version.equals(mc.version) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.uniqueName.hashCode();
        result = 31 * result + this.className.hashCode();
        return result;
    }

    @Override
    public MConnector clone(boolean cloneWithValue) {
        cloneWithValue = false;
        ArrayList<MJobForms> copyJobForms = null;
        if (this.getAllJobsForms() != null) {
            copyJobForms = new ArrayList<MJobForms>();
            for (MJobForms entry : this.getAllJobsForms().values()) {
                copyJobForms.add(entry.clone(cloneWithValue));
            }
        }
        MConnector copy = new MConnector(this.getUniqueName(), this.getClassName(), this.getVersion(), this.getConnectionForms().clone(cloneWithValue), copyJobForms);
        copy.setPersistenceId(this.getPersistenceId());
        return copy;
    }
}

