/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.ConfigurationClass;
import org.apache.sqoop.model.Form;
import org.apache.sqoop.model.FormClass;
import org.apache.sqoop.model.Input;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MValidatedElement;
import org.apache.sqoop.model.ModelError;
import org.apache.sqoop.utils.ClassUtils;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class FormUtils {
    public static List<MForm> toForms(Object configuration) {
        return FormUtils.toForms(configuration.getClass(), configuration);
    }

    public static List<MForm> toForms(Class klass) {
        return FormUtils.toForms(klass, null);
    }

    public static List<MForm> toForms(Class klass, Object configuration) {
        ConfigurationClass global = klass.getAnnotation(ConfigurationClass.class);
        if (global == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation ConfigurationClass on class " + klass.getName());
        }
        LinkedList<MForm> forms = new LinkedList<MForm>();
        for (Field field : klass.getDeclaredFields()) {
            field.setAccessible(true);
            String formName = field.getName();
            Form formAnnotation = field.getAnnotation(Form.class);
            if (formAnnotation == null) continue;
            Class<?> type = field.getType();
            Object value = null;
            if (configuration != null) {
                try {
                    value = field.get(configuration);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Can't retrieve value from " + field.getName(), e);
                }
            }
            forms.add(FormUtils.toForm(formName, type, value));
        }
        return forms;
    }

    private static MForm toForm(String formName, Class klass, Object object) {
        FormClass global = klass.getAnnotation(FormClass.class);
        if (global == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation FormClass on class " + klass.getName());
        }
        LinkedList inputs = new LinkedList();
        for (Field field : klass.getDeclaredFields()) {
            MInput input;
            field.setAccessible(true);
            String fieldName = field.getName();
            String inputName = formName + "." + fieldName;
            Input inputAnnotation = field.getAnnotation(Input.class);
            if (inputAnnotation == null) continue;
            boolean sensitive = inputAnnotation.sensitive();
            short maxLen = inputAnnotation.size();
            Class<Map> type = field.getType();
            if (type.isPrimitive()) {
                throw new SqoopException((ErrorCode)ModelError.MODEL_007, "Detected primitive type " + type + " for field " + fieldName);
            }
            if (type == String.class) {
                input = new MStringInput(inputName, sensitive, maxLen);
            } else if (type.isAssignableFrom(Map.class)) {
                input = new MMapInput(inputName, sensitive);
            } else if (type == Integer.class) {
                input = new MIntegerInput(inputName, sensitive);
            } else if (type == Boolean.class) {
                input = new MBooleanInput(inputName, sensitive);
            } else if (type.isEnum()) {
                input = new MEnumInput(inputName, sensitive, ClassUtils.getEnumStrings(type));
            } else {
                throw new SqoopException((ErrorCode)ModelError.MODEL_004, "Unsupported type " + type.getName() + " for input " + fieldName);
            }
            if (object != null) {
                Object value;
                try {
                    value = field.get(object);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Can't retrieve value from " + field.getName(), e);
                }
                if (value == null) {
                    input.setEmpty();
                } else {
                    input.setValue(value);
                }
            }
            inputs.add(input);
        }
        return new MForm(formName, inputs);
    }

    public static void fromForms(List<MForm> forms, Object configuration) {
        Class<?> klass = configuration.getClass();
        for (MForm form : forms) {
            Field formField;
            try {
                formField = klass.getDeclaredField(form.getName());
            }
            catch (NoSuchFieldException e) {
                throw new SqoopException(ModelError.MODEL_006, "Missing field " + form.getName() + " on form class " + klass.getCanonicalName(), e);
            }
            formField.setAccessible(true);
            Class<?> formClass = formField.getType();
            Object newValue = ClassUtils.instantiate(formClass, new Object[0]);
            if (newValue == null) {
                throw new SqoopException((ErrorCode)ModelError.MODEL_006, "Can't instantiate new form " + formClass);
            }
            for (MInput<?> input : form.getInputs()) {
                Field inputField;
                String[] splitNames = input.getName().split("\\.");
                if (splitNames.length != 2) {
                    throw new SqoopException((ErrorCode)ModelError.MODEL_009, "Invalid name: " + input.getName());
                }
                String inputName = splitNames[1];
                try {
                    inputField = formClass.getDeclaredField(inputName);
                }
                catch (NoSuchFieldException e) {
                    throw new SqoopException(ModelError.MODEL_006, "Missing field " + input.getName(), e);
                }
                inputField.setAccessible(true);
                try {
                    if (input.isEmpty()) {
                        inputField.set(newValue, null);
                        continue;
                    }
                    if (input.getType() == MInputType.ENUM) {
                        inputField.set(newValue, Enum.valueOf(inputField.getType(), (String)input.getValue()));
                        continue;
                    }
                    inputField.set(newValue, input.getValue());
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Issue with field " + inputField.getName(), e);
                }
            }
            try {
                formField.set(configuration, newValue);
            }
            catch (IllegalAccessException e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + formField.getName(), e);
            }
        }
    }

    public static void applyValidation(List<MForm> forms, Validation validation) {
        Map<Validation.FormInput, Validation.Message> messages = validation.getMessages();
        for (MForm form : forms) {
            FormUtils.applyValidation(form, messages);
            for (MInput<?> input : form.getInputs()) {
                FormUtils.applyValidation(input, messages);
            }
        }
    }

    public static void applyValidation(MValidatedElement element, Map<Validation.FormInput, Validation.Message> messages) {
        Validation.FormInput name = new Validation.FormInput(element.getName());
        if (messages.containsKey(name)) {
            Validation.Message message = messages.get(name);
            element.setValidationMessage(message.getStatus(), message.getMessage());
        } else {
            element.setValidationMessage(Status.getDefault(), null);
        }
    }

    public static String toJson(Object configuration) {
        Class<?> klass = configuration.getClass();
        ConfigurationClass global = klass.getAnnotation(ConfigurationClass.class);
        if (global == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation Configuration on class " + klass.getName());
        }
        JSONObject jsonOutput = new JSONObject();
        for (Field formField : klass.getDeclaredFields()) {
            Object formValue;
            formField.setAccessible(true);
            String formName = formField.getName();
            Form formAnnotation = formField.getAnnotation(Form.class);
            if (formAnnotation == null) continue;
            try {
                formValue = formField.get(configuration);
            }
            catch (IllegalAccessException e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + formName, e);
            }
            JSONObject jsonForm = new JSONObject();
            for (Field inputField : formField.getType().getDeclaredFields()) {
                Object value;
                inputField.setAccessible(true);
                String inputName = inputField.getName();
                try {
                    value = inputField.get(formValue);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Issue with field " + formName + "." + inputName, e);
                }
                Input inputAnnotation = inputField.getAnnotation(Input.class);
                if (inputAnnotation == null || value == null) continue;
                Class<Map> type = inputField.getType();
                if (type.isPrimitive()) {
                    throw new SqoopException((ErrorCode)ModelError.MODEL_007, "Detected primitive type " + type + " for field " + formName + "." + inputName);
                }
                if (type == String.class) {
                    jsonForm.put((Object)inputName, value);
                    continue;
                }
                if (type.isAssignableFrom(Map.class)) {
                    JSONObject map = new JSONObject();
                    for (Object key : ((Map)value).keySet()) {
                        map.put(key, ((Map)value).get(key));
                    }
                    jsonForm.put((Object)inputName, (Object)map);
                    continue;
                }
                if (type == Integer.class) {
                    jsonForm.put((Object)inputName, value);
                    continue;
                }
                if (type.isEnum()) {
                    jsonForm.put((Object)inputName, (Object)value.toString());
                    continue;
                }
                if (type == Boolean.class) {
                    jsonForm.put((Object)inputName, value);
                    continue;
                }
                throw new SqoopException((ErrorCode)ModelError.MODEL_004, "Unsupported type " + type.getName() + " for input " + formName + "." + inputName);
            }
            jsonOutput.put((Object)formName, (Object)jsonForm);
        }
        return jsonOutput.toJSONString();
    }

    public static void fillValues(String json, Object configuration) {
        Class<?> klass = configuration.getClass();
        JSONObject jsonForms = (JSONObject)JSONValue.parse((String)json);
        for (Field formField : klass.getDeclaredFields()) {
            Object formValue;
            formField.setAccessible(true);
            String formName = formField.getName();
            Form formAnnotation = formField.getAnnotation(Form.class);
            if (formAnnotation == null) continue;
            try {
                formField.set(configuration, formField.getType().newInstance());
            }
            catch (Exception e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + formName, e);
            }
            JSONObject jsonInputs = (JSONObject)jsonForms.get((Object)formField.getName());
            if (jsonInputs == null) continue;
            try {
                formValue = formField.get(configuration);
            }
            catch (IllegalAccessException e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + formName, e);
            }
            for (Field inputField : formField.getType().getDeclaredFields()) {
                inputField.setAccessible(true);
                String inputName = inputField.getName();
                Input inputAnnotation = inputField.getAnnotation(Input.class);
                if (inputAnnotation == null || jsonInputs.get((Object)inputName) == null) {
                    try {
                        inputField.set(formValue, null);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new SqoopException(ModelError.MODEL_005, "Issue with field " + formName + "." + inputName, e);
                    }
                }
                Class<Map> type = inputField.getType();
                try {
                    if (type == String.class) {
                        inputField.set(formValue, jsonInputs.get((Object)inputName));
                        continue;
                    }
                    if (type.isAssignableFrom(Map.class)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        JSONObject jsonObject = (JSONObject)jsonInputs.get((Object)inputName);
                        for (Object key : jsonObject.keySet()) {
                            map.put((String)key, (String)jsonObject.get(key));
                        }
                        inputField.set(formValue, map);
                        continue;
                    }
                    if (type == Integer.class) {
                        inputField.set(formValue, ((Long)jsonInputs.get((Object)inputName)).intValue());
                        continue;
                    }
                    if (type.isEnum()) {
                        inputField.set(formValue, Enum.valueOf(inputField.getType(), (String)jsonInputs.get((Object)inputName)));
                        continue;
                    }
                    if (type == Boolean.class) {
                        inputField.set(formValue, (Boolean)jsonInputs.get((Object)inputName));
                        continue;
                    }
                    throw new SqoopException((ErrorCode)ModelError.MODEL_004, "Unsupported type " + type.getName() + " for input " + formName + "." + inputName);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Issue with field " + formName + "." + inputName, e);
                }
            }
        }
    }
}

