/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.utils.MapResourceBundle;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class ResourceBundleSerialization {
    public static final String RESOURCES = "resources";
    public static final String CONNECTOR_RESOURCES = "resources-connector";
    public static final String FRAMEWORK_RESOURCES = "resources-framework";

    public static JSONArray extractResourceBundles(List<ResourceBundle> bundles) {
        JSONArray array = new JSONArray();
        for (ResourceBundle bundle : bundles) {
            array.add((Object)ResourceBundleSerialization.extractResourceBundle(bundle));
        }
        return array;
    }

    public static JSONObject extractResourceBundle(ResourceBundle bundle) {
        JSONObject json = new JSONObject();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            json.put((Object)key, (Object)bundle.getString(key));
        }
        return json;
    }

    public static List<ResourceBundle> restoreResourceBundles(JSONArray array) {
        LinkedList<ResourceBundle> bundles = new LinkedList<ResourceBundle>();
        for (Object item : array) {
            bundles.add(ResourceBundleSerialization.restoreResourceBundle((JSONObject)item));
        }
        return bundles;
    }

    public static ResourceBundle restoreResourceBundle(JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll((Map<String, Object>)json);
        return new MapResourceBundle(map);
    }

    private ResourceBundleSerialization() {
    }
}

