/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import org.apache.sqoop.json.JsonBean;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class VersionBean
implements JsonBean {
    public static final String VERSION = "version";
    public static final String REVISION = "revision";
    public static final String DATE = "date";
    public static final String USER = "user";
    public static final String URL = "url";
    public static final String PROTOCOLS = "protocols";
    private String version;
    private String revision;
    private String date;
    private String user;
    private String url;
    private String[] protocols;

    public VersionBean(String version, String revision, String date, String user, String url, String[] protocols) {
        this.version = version;
        this.revision = revision;
        this.date = date;
        this.user = user;
        this.url = url;
        this.protocols = new String[protocols.length];
        System.arraycopy(protocols, 0, this.protocols, 0, protocols.length);
    }

    public VersionBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject result = new JSONObject();
        result.put((Object)VERSION, (Object)this.version);
        result.put((Object)REVISION, (Object)this.revision);
        result.put((Object)DATE, (Object)this.date);
        result.put((Object)USER, (Object)this.user);
        result.put((Object)URL, (Object)this.url);
        JSONArray protocolsArray = new JSONArray();
        for (String protocol : this.protocols) {
            protocolsArray.add((Object)protocol);
        }
        result.put((Object)PROTOCOLS, (Object)protocolsArray);
        return result;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.version = (String)jsonObject.get((Object)VERSION);
        this.revision = (String)jsonObject.get((Object)REVISION);
        this.date = (String)jsonObject.get((Object)DATE);
        this.user = (String)jsonObject.get((Object)USER);
        this.url = (String)jsonObject.get((Object)URL);
        JSONArray protocolsArray = (JSONArray)jsonObject.get((Object)PROTOCOLS);
        int size = protocolsArray.size();
        this.protocols = new String[size];
        for (int i = 0; i < size; ++i) {
            this.protocols[i] = (String)protocolsArray.get(i);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getDate() {
        return this.date;
    }

    public String getUser() {
        return this.user;
    }

    public String getUrl() {
        return this.url;
    }

    public String[] getProtocols() {
        return this.protocols;
    }
}

