/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.HashMap;
import java.util.Map;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;
import org.json.simple.JSONObject;

public class ValidationBean
implements JsonBean {
    private static final String ID = "id";
    private static final String FRAMEWORK = "framework";
    private static final String CONNECTOR = "connector";
    private static final String STATUS = "status";
    private static final String MESSAGE = "message";
    private static final String MESSAGES = "messages";
    private Long id = null;
    private Validation connectorValidation;
    private Validation frameworkValidation;

    public ValidationBean(Validation connector, Validation framework) {
        this();
        this.connectorValidation = connector;
        this.frameworkValidation = framework;
    }

    public ValidationBean() {
    }

    public Validation getConnectorValidation() {
        return this.connectorValidation;
    }

    public Validation getFrameworkValidation() {
        return this.frameworkValidation;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject object = new JSONObject();
        if (this.id != null) {
            object.put((Object)ID, (Object)this.id);
        }
        object.put((Object)CONNECTOR, (Object)this.extractValidation(this.connectorValidation));
        object.put((Object)FRAMEWORK, (Object)this.extractValidation(this.frameworkValidation));
        return object;
    }

    private JSONObject extractValidation(Validation validation) {
        JSONObject object = new JSONObject();
        object.put((Object)STATUS, (Object)validation.getStatus().name());
        JSONObject jsonMessages = new JSONObject();
        Map<Validation.FormInput, Validation.Message> messages = validation.getMessages();
        for (Map.Entry<Validation.FormInput, Validation.Message> entry : messages.entrySet()) {
            JSONObject jsonEntry = new JSONObject();
            jsonEntry.put((Object)STATUS, (Object)entry.getValue().getStatus().name());
            jsonEntry.put((Object)MESSAGE, (Object)entry.getValue().getMessage());
            jsonMessages.put((Object)entry.getKey(), (Object)jsonEntry);
        }
        object.put((Object)MESSAGES, (Object)jsonMessages);
        return object;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.id = (Long)jsonObject.get((Object)ID);
        this.connectorValidation = this.restoreValidation((JSONObject)jsonObject.get((Object)CONNECTOR));
        this.frameworkValidation = this.restoreValidation((JSONObject)jsonObject.get((Object)FRAMEWORK));
    }

    public Validation restoreValidation(JSONObject jsonObject) {
        JSONObject jsonMessages = (JSONObject)jsonObject.get((Object)MESSAGES);
        HashMap<Validation.FormInput, Validation.Message> messages = new HashMap<Validation.FormInput, Validation.Message>();
        for (Object key : jsonMessages.keySet()) {
            JSONObject jsonMessage = (JSONObject)jsonMessages.get(key);
            Status status = Status.valueOf((String)jsonMessage.get((Object)STATUS));
            String stringMessage = (String)jsonMessage.get((Object)MESSAGE);
            Validation.Message message = new Validation.Message(status, stringMessage);
            messages.put(new Validation.FormInput((String)key), message);
        }
        Status status = Status.valueOf((String)jsonObject.get((Object)STATUS));
        return new Validation(status, messages);
    }
}

