/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.SchemaSerialization;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counter;
import org.apache.sqoop.submission.counter.CounterGroup;
import org.apache.sqoop.submission.counter.Counters;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SubmissionBean
implements JsonBean {
    private static final String ALL = "all";
    private static final String JOB = "job";
    private static final String CREATION_USER = "creation-user";
    private static final String CREATION_DATE = "creation-date";
    private static final String LAST_UPDATE_USER = "last-udpate-user";
    private static final String LAST_UPDATE_DATE = "last-update-date";
    private static final String STATUS = "status";
    private static final String EXTERNAL_ID = "external-id";
    private static final String EXTERNAL_LINK = "external-link";
    private static final String EXCEPTION = "exception";
    private static final String EXCEPTION_TRACE = "exception-trace";
    private static final String PROGRESS = "progress";
    private static final String COUNTERS = "counters";
    private static final String CONNECTOR_SCHEMA = "schema-connector";
    private static final String HIO_SCHEMA = "schema-hio";
    private List<MSubmission> submissions;

    public List<MSubmission> getSubmissions() {
        return this.submissions;
    }

    public SubmissionBean(MSubmission submission) {
        this();
        this.submissions = new ArrayList<MSubmission>();
        this.submissions.add(submission);
    }

    public SubmissionBean(List<MSubmission> submissions) {
        this();
        this.submissions = submissions;
    }

    public SubmissionBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray array = new JSONArray();
        for (MSubmission submission : this.submissions) {
            JSONObject object = new JSONObject();
            object.put((Object)JOB, (Object)submission.getJobId());
            object.put((Object)STATUS, (Object)submission.getStatus().name());
            object.put((Object)PROGRESS, (Object)submission.getProgress());
            if (submission.getCreationUser() != null) {
                object.put((Object)CREATION_USER, (Object)submission.getCreationUser());
            }
            if (submission.getCreationDate() != null) {
                object.put((Object)CREATION_DATE, (Object)submission.getCreationDate().getTime());
            }
            if (submission.getLastUpdateUser() != null) {
                object.put((Object)LAST_UPDATE_USER, (Object)submission.getLastUpdateUser());
            }
            if (submission.getLastUpdateDate() != null) {
                object.put((Object)LAST_UPDATE_DATE, (Object)submission.getLastUpdateDate().getTime());
            }
            if (submission.getExternalId() != null) {
                object.put((Object)EXTERNAL_ID, (Object)submission.getExternalId());
            }
            if (submission.getExternalLink() != null) {
                object.put((Object)EXTERNAL_LINK, (Object)submission.getExternalLink());
            }
            if (submission.getExceptionInfo() != null) {
                object.put((Object)EXCEPTION, (Object)submission.getExceptionInfo());
            }
            if (submission.getExceptionStackTrace() != null) {
                object.put((Object)EXCEPTION_TRACE, (Object)submission.getExceptionStackTrace());
            }
            if (submission.getCounters() != null) {
                object.put((Object)COUNTERS, (Object)this.extractCounters(submission.getCounters()));
            }
            if (submission.getConnectorSchema() != null) {
                object.put((Object)CONNECTOR_SCHEMA, (Object)SchemaSerialization.extractSchema(submission.getConnectorSchema()));
            }
            if (submission.getHioSchema() != null) {
                object.put((Object)HIO_SCHEMA, (Object)SchemaSerialization.extractSchema(submission.getHioSchema()));
            }
            array.add((Object)object);
        }
        JSONObject all = new JSONObject();
        all.put((Object)ALL, (Object)array);
        return all;
    }

    public JSONObject extractCounters(Counters counters) {
        JSONObject ret = new JSONObject();
        for (CounterGroup group : counters) {
            JSONObject counterGroup = new JSONObject();
            for (Counter counter : group) {
                counterGroup.put((Object)counter.getName(), (Object)counter.getValue());
            }
            ret.put((Object)group.getName(), (Object)counterGroup);
        }
        return ret;
    }

    @Override
    public void restore(JSONObject json) {
        this.submissions = new ArrayList<MSubmission>();
        JSONArray array = (JSONArray)json.get((Object)ALL);
        for (Object obj : array) {
            JSONObject object = (JSONObject)obj;
            MSubmission submission = new MSubmission();
            submission.setJobId((Long)object.get((Object)JOB));
            submission.setStatus(SubmissionStatus.valueOf((String)object.get((Object)STATUS)));
            submission.setProgress((Double)object.get((Object)PROGRESS));
            if (object.containsKey((Object)CREATION_USER)) {
                submission.setCreationUser((String)object.get((Object)CREATION_USER));
            }
            if (object.containsKey((Object)CREATION_DATE)) {
                submission.setCreationDate(new Date((Long)object.get((Object)CREATION_DATE)));
            }
            if (object.containsKey((Object)LAST_UPDATE_USER)) {
                submission.setLastUpdateUser((String)object.get((Object)LAST_UPDATE_USER));
            }
            if (object.containsKey((Object)LAST_UPDATE_DATE)) {
                submission.setLastUpdateDate(new Date((Long)object.get((Object)LAST_UPDATE_DATE)));
            }
            if (object.containsKey((Object)EXTERNAL_ID)) {
                submission.setExternalId((String)object.get((Object)EXTERNAL_ID));
            }
            if (object.containsKey((Object)EXTERNAL_LINK)) {
                submission.setExternalLink((String)object.get((Object)EXTERNAL_LINK));
            }
            if (object.containsKey((Object)EXCEPTION)) {
                submission.setExceptionInfo((String)object.get((Object)EXCEPTION));
            }
            if (object.containsKey((Object)EXCEPTION_TRACE)) {
                submission.setExceptionStackTrace((String)object.get((Object)EXCEPTION_TRACE));
            }
            if (object.containsKey((Object)COUNTERS)) {
                submission.setCounters(this.restoreCounters((JSONObject)object.get((Object)COUNTERS)));
            }
            if (object.containsKey((Object)CONNECTOR_SCHEMA)) {
                submission.setConnectorSchema(SchemaSerialization.restoreSchemna((JSONObject)object.get((Object)CONNECTOR_SCHEMA)));
            }
            if (object.containsKey((Object)HIO_SCHEMA)) {
                submission.setHioSchema(SchemaSerialization.restoreSchemna((JSONObject)object.get((Object)HIO_SCHEMA)));
            }
            this.submissions.add(submission);
        }
    }

    public Counters restoreCounters(JSONObject object) {
        Set groupSet = object.entrySet();
        Counters counters = new Counters();
        for (Map.Entry groupEntry : groupSet) {
            CounterGroup group = new CounterGroup((String)groupEntry.getKey());
            Set counterSet = ((JSONObject)groupEntry.getValue()).entrySet();
            for (Map.Entry counterEntry : counterSet) {
                Counter counter = new Counter((String)counterEntry.getKey(), (Long)counterEntry.getValue());
                group.addCounter(counter);
            }
            counters.addCounterGroup(group);
        }
        return counters;
    }
}

