/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.FormSerialization;
import org.apache.sqoop.json.util.ResourceBundleSerialization;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JobBean
implements JsonBean {
    private static final String ALL = "all";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String CONNECTION_ID = "connection-id";
    private static final String CONNECTOR_ID = "connector-id";
    private static final String CONNECTOR_PART = "connector";
    private static final String FRAMEWORK_PART = "framework";
    private List<MJob> jobs;
    private Map<Long, ResourceBundle> connectorBundles = new HashMap<Long, ResourceBundle>();
    private ResourceBundle frameworkBundle;

    public JobBean(MJob job) {
        this();
        this.jobs = new ArrayList<MJob>();
        this.jobs.add(job);
    }

    public JobBean(List<MJob> jobs) {
        this();
        this.jobs = jobs;
    }

    public JobBean() {
    }

    public void setFrameworkBundle(ResourceBundle frameworkBundle) {
        this.frameworkBundle = frameworkBundle;
    }

    public void addConnectorBundle(Long id, ResourceBundle connectorBundle) {
        this.connectorBundles.put(id, connectorBundle);
    }

    public boolean hasConnectorBundle(Long id) {
        return this.connectorBundles.containsKey(id);
    }

    public List<MJob> getJobs() {
        return this.jobs;
    }

    public ResourceBundle getConnectorBundle(Long id) {
        return this.connectorBundles.get(id);
    }

    public ResourceBundle getFrameworkBundle() {
        return this.frameworkBundle;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray array = new JSONArray();
        for (MJob job : this.jobs) {
            JSONObject object = new JSONObject();
            object.put((Object)ID, (Object)job.getPersistenceId());
            object.put((Object)NAME, (Object)job.getName());
            object.put((Object)TYPE, (Object)job.getType().name());
            object.put((Object)"enabled", (Object)job.getEnabled());
            object.put((Object)"creation-user", (Object)job.getCreationUser());
            object.put((Object)"creation-date", (Object)job.getCreationDate().getTime());
            object.put((Object)"update-user", (Object)job.getLastUpdateUser());
            object.put((Object)"update-date", (Object)job.getLastUpdateDate().getTime());
            object.put((Object)CONNECTION_ID, (Object)job.getConnectionId());
            object.put((Object)CONNECTOR_ID, (Object)job.getConnectorId());
            object.put((Object)CONNECTOR_PART, (Object)FormSerialization.extractForms(job.getConnectorPart().getForms(), skipSensitive));
            object.put((Object)FRAMEWORK_PART, (Object)FormSerialization.extractForms(job.getFrameworkPart().getForms(), skipSensitive));
            array.add((Object)object);
        }
        JSONObject all = new JSONObject();
        all.put((Object)ALL, (Object)array);
        if (!this.connectorBundles.isEmpty()) {
            JSONObject bundles = new JSONObject();
            for (Map.Entry<Long, ResourceBundle> entry : this.connectorBundles.entrySet()) {
                bundles.put((Object)entry.getKey().toString(), (Object)ResourceBundleSerialization.extractResourceBundle(entry.getValue()));
            }
            all.put((Object)"resources-connector", (Object)bundles);
        }
        if (this.frameworkBundle != null) {
            all.put((Object)"resources-framework", (Object)ResourceBundleSerialization.extractResourceBundle(this.frameworkBundle));
        }
        return all;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.jobs = new ArrayList<MJob>();
        JSONArray array = (JSONArray)jsonObject.get((Object)ALL);
        for (Object obj : array) {
            JSONObject object = (JSONObject)obj;
            long connectorId = (Long)object.get((Object)CONNECTOR_ID);
            long connectionId = (Long)object.get((Object)CONNECTION_ID);
            JSONArray connectorPart = (JSONArray)object.get((Object)CONNECTOR_PART);
            JSONArray frameworkPart = (JSONArray)object.get((Object)FRAMEWORK_PART);
            String stringType = (String)object.get((Object)TYPE);
            MJob.Type type = MJob.Type.valueOf(stringType);
            List<MForm> connectorForms = FormSerialization.restoreForms(connectorPart);
            List<MForm> frameworkForms = FormSerialization.restoreForms(frameworkPart);
            MJob job = new MJob(connectorId, connectionId, type, new MJobForms(type, connectorForms), new MJobForms(type, frameworkForms));
            job.setPersistenceId((Long)object.get((Object)ID));
            job.setName((String)object.get((Object)NAME));
            job.setEnabled((Boolean)object.get((Object)"enabled"));
            job.setCreationUser((String)object.get((Object)"creation-user"));
            job.setCreationDate(new Date((Long)object.get((Object)"creation-date")));
            job.setLastUpdateUser((String)object.get((Object)"update-user"));
            job.setLastUpdateDate(new Date((Long)object.get((Object)"update-date")));
            this.jobs.add(job);
        }
        if (jsonObject.containsKey((Object)"resources-connector")) {
            JSONObject bundles = (JSONObject)jsonObject.get((Object)"resources-connector");
            Set entrySet = bundles.entrySet();
            for (Map.Entry entry : entrySet) {
                this.connectorBundles.put(Long.parseLong((String)entry.getKey()), ResourceBundleSerialization.restoreResourceBundle((JSONObject)entry.getValue()));
            }
        }
        if (jsonObject.containsKey((Object)"resources-framework")) {
            this.frameworkBundle = ResourceBundleSerialization.restoreResourceBundle((JSONObject)jsonObject.get((Object)"resources-framework"));
        }
    }
}

