/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.FormSerialization;
import org.apache.sqoop.json.util.ResourceBundleSerialization;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MForm;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConnectionBean
implements JsonBean {
    private static final String CONNECTOR_ID = "connector-id";
    private static final String CONNECTOR_PART = "connector";
    private static final String FRAMEWORK_PART = "framework";
    private List<MConnection> connections;
    private Map<Long, ResourceBundle> connectorBundles = new HashMap<Long, ResourceBundle>();
    private ResourceBundle frameworkBundle;

    public ConnectionBean(MConnection connection) {
        this();
        this.connections = new ArrayList<MConnection>();
        this.connections.add(connection);
    }

    public ConnectionBean(List<MConnection> connections) {
        this();
        this.connections = connections;
    }

    public ConnectionBean() {
    }

    public void setFrameworkBundle(ResourceBundle frameworkBundle) {
        this.frameworkBundle = frameworkBundle;
    }

    public void addConnectorBundle(Long id, ResourceBundle connectorBundle) {
        this.connectorBundles.put(id, connectorBundle);
    }

    public boolean hasConnectorBundle(Long id) {
        return this.connectorBundles.containsKey(id);
    }

    public List<MConnection> getConnections() {
        return this.connections;
    }

    public ResourceBundle getConnectorBundle(Long id) {
        return this.connectorBundles.get(id);
    }

    public ResourceBundle getFrameworkBundle() {
        return this.frameworkBundle;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONArray array = new JSONArray();
        for (MConnection connection : this.connections) {
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)connection.getPersistenceId());
            object.put((Object)"name", (Object)connection.getName());
            object.put((Object)"enabled", (Object)connection.getEnabled());
            object.put((Object)"creation-user", (Object)connection.getCreationUser());
            object.put((Object)"creation-date", (Object)connection.getCreationDate().getTime());
            object.put((Object)"update-user", (Object)connection.getLastUpdateUser());
            object.put((Object)"update-date", (Object)connection.getLastUpdateDate().getTime());
            object.put((Object)CONNECTOR_ID, (Object)connection.getConnectorId());
            object.put((Object)CONNECTOR_PART, (Object)FormSerialization.extractForms(connection.getConnectorPart().getForms(), skipSensitive));
            object.put((Object)FRAMEWORK_PART, (Object)FormSerialization.extractForms(connection.getFrameworkPart().getForms(), skipSensitive));
            array.add((Object)object);
        }
        JSONObject all = new JSONObject();
        all.put((Object)"all", (Object)array);
        if (!this.connectorBundles.isEmpty()) {
            JSONObject bundles = new JSONObject();
            for (Map.Entry<Long, ResourceBundle> entry : this.connectorBundles.entrySet()) {
                bundles.put((Object)entry.getKey().toString(), (Object)ResourceBundleSerialization.extractResourceBundle(entry.getValue()));
            }
            all.put((Object)"resources-connector", (Object)bundles);
        }
        if (this.frameworkBundle != null) {
            all.put((Object)"resources-framework", (Object)ResourceBundleSerialization.extractResourceBundle(this.frameworkBundle));
        }
        return all;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.connections = new ArrayList<MConnection>();
        JSONArray array = (JSONArray)jsonObject.get((Object)"all");
        for (Object obj : array) {
            JSONObject object = (JSONObject)obj;
            long connectorId = (Long)object.get((Object)CONNECTOR_ID);
            JSONArray connectorPart = (JSONArray)object.get((Object)CONNECTOR_PART);
            JSONArray frameworkPart = (JSONArray)object.get((Object)FRAMEWORK_PART);
            List<MForm> connectorForms = FormSerialization.restoreForms(connectorPart);
            List<MForm> frameworkForms = FormSerialization.restoreForms(frameworkPart);
            MConnection connection = new MConnection(connectorId, new MConnectionForms(connectorForms), new MConnectionForms(frameworkForms));
            connection.setPersistenceId((Long)object.get((Object)"id"));
            connection.setName((String)object.get((Object)"name"));
            connection.setEnabled((Boolean)object.get((Object)"enabled"));
            connection.setCreationUser((String)object.get((Object)"creation-user"));
            connection.setCreationDate(new Date((Long)object.get((Object)"creation-date")));
            connection.setLastUpdateUser((String)object.get((Object)"update-user"));
            connection.setLastUpdateDate(new Date((Long)object.get((Object)"update-date")));
            this.connections.add(connection);
        }
        if (jsonObject.containsKey((Object)"resources-connector")) {
            JSONObject bundles = (JSONObject)jsonObject.get((Object)"resources-connector");
            Set entrySet = bundles.entrySet();
            for (Map.Entry entry : entrySet) {
                this.connectorBundles.put(Long.parseLong((String)entry.getKey()), ResourceBundleSerialization.restoreResourceBundle((JSONObject)entry.getValue()));
            }
        }
        if (jsonObject.containsKey((Object)"resources-framework")) {
            this.frameworkBundle = ResourceBundleSerialization.restoreResourceBundle((JSONObject)jsonObject.get((Object)"resources-framework"));
        }
    }
}

