/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MStringInput;
import org.junit.Assert;
import org.junit.Test;

public class TestMStringInput {
    @Test
    public void testInitialization() {
        short len = 6;
        MStringInput input = new MStringInput("sqoopsqoop", true, len);
        Assert.assertEquals((Object)"sqoopsqoop", (Object)input.getName());
        Assert.assertEquals((Object)true, (Object)input.isSensitive());
        Assert.assertEquals((long)len, (long)input.getMaxLength());
        Assert.assertEquals((Object)MInputType.STRING, (Object)input.getType());
    }

    @Test
    public void testEquals() {
        short len = 6;
        MStringInput input1 = new MStringInput("sqoopsqoop", true, len);
        MStringInput input2 = new MStringInput("sqoopsqoop", true, len);
        Assert.assertTrue((boolean)input1.equals((Object)input2));
        MStringInput input3 = new MStringInput("sqoopsqoop", false, len);
        MStringInput input4 = new MStringInput("sqoopsqoop", true, len);
        Assert.assertFalse((boolean)input3.equals((Object)input4));
    }

    @Test
    public void testValue() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, 5);
        input1.setValue((Object)"sqoop");
        Assert.assertEquals((Object)"sqoop", (Object)input1.getValue());
        input1.setEmpty();
        Assert.assertNull((Object)input1.getValue());
    }

    @Test
    public void testUrlSafe() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, 5);
        String s = "Sqoop%$!@#&*()Sqoop";
        input1.setValue((Object)s);
        String tmp = input1.getUrlSafeValueString();
        input1.restoreFromUrlSafeValueString(tmp);
        Assert.assertEquals((Object)s, (Object)input1.getValue());
    }

    @Test
    public void testNamedElement() {
        MStringInput input1 = new MStringInput("sqoopsqoop", true, 5);
        Assert.assertEquals((Object)"sqoopsqoop.label", (Object)input1.getLabelKey());
        Assert.assertEquals((Object)"sqoopsqoop.help", (Object)input1.getHelpKey());
    }
}

