/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MConnectionForms;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.junit.Assert;
import org.junit.Test;

public class TestMConnection {
    @Test
    public void testInitialization() {
        MConnection connection = this.connection();
        Assert.assertEquals((long)123L, (long)connection.getConnectorId());
        Assert.assertEquals((Object)"Vampire", (Object)connection.getName());
        Assert.assertEquals((Object)"Buffy", (Object)connection.getCreationUser());
        Assert.assertEquals((Object)this.forms1(), (Object)connection.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(), (Object)connection.getFrameworkPart());
        MConnection copy = new MConnection(connection);
        Assert.assertEquals((long)123L, (long)copy.getConnectorId());
        Assert.assertEquals((Object)"Vampire", (Object)copy.getName());
        Assert.assertEquals((Object)"Buffy", (Object)copy.getCreationUser());
        Assert.assertEquals((Object)connection.getCreationDate(), (Object)copy.getCreationDate());
        Assert.assertEquals((Object)this.forms1(), (Object)copy.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(), (Object)copy.getFrameworkPart());
        MConnection upgradeCopy = new MConnection(connection, this.forms2(), this.forms1());
        Assert.assertEquals((long)123L, (long)upgradeCopy.getConnectorId());
        Assert.assertEquals((Object)"Vampire", (Object)upgradeCopy.getName());
        Assert.assertEquals((Object)"Buffy", (Object)upgradeCopy.getCreationUser());
        Assert.assertEquals((Object)connection.getCreationDate(), (Object)upgradeCopy.getCreationDate());
        Assert.assertEquals((Object)this.forms2(), (Object)upgradeCopy.getConnectorPart());
        Assert.assertEquals((Object)this.forms1(), (Object)upgradeCopy.getFrameworkPart());
    }

    @Test
    public void testClone() {
        MConnection connection = this.connection();
        MConnection withoutValue = connection.clone(false);
        Assert.assertEquals((Object)connection, (Object)withoutValue);
        Assert.assertEquals((long)-1L, (long)withoutValue.getPersistenceId());
        Assert.assertNull((Object)withoutValue.getName());
        Assert.assertNull((Object)withoutValue.getCreationUser());
        Assert.assertEquals((Object)this.forms1(), (Object)withoutValue.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(), (Object)withoutValue.getFrameworkPart());
        Assert.assertNull((Object)withoutValue.getConnectorPart().getForm("FORMNAME").getInput("INTEGER-INPUT").getValue());
        Assert.assertNull((Object)withoutValue.getConnectorPart().getForm("FORMNAME").getInput("STRING-INPUT").getValue());
        MConnection withValue = connection.clone(true);
        Assert.assertEquals((Object)connection, (Object)withValue);
        Assert.assertEquals((long)connection.getPersistenceId(), (long)withValue.getPersistenceId());
        Assert.assertEquals((Object)connection.getName(), (Object)withValue.getName());
        Assert.assertEquals((Object)connection.getCreationUser(), (Object)withValue.getCreationUser());
        Assert.assertEquals((Object)this.forms1(), (Object)withValue.getConnectorPart());
        Assert.assertEquals((Object)this.forms2(), (Object)withValue.getFrameworkPart());
        Assert.assertEquals((Object)100, (Object)withValue.getConnectorPart().getForm("FORMNAME").getInput("INTEGER-INPUT").getValue());
        Assert.assertEquals((Object)"TEST-VALUE", (Object)withValue.getConnectorPart().getForm("FORMNAME").getInput("STRING-INPUT").getValue());
    }

    private MConnection connection() {
        MConnection connection = new MConnection(123L, this.forms1(), this.forms2());
        connection.setName("Vampire");
        connection.setCreationUser("Buffy");
        return connection;
    }

    private MConnectionForms forms1() {
        ArrayList<MForm> forms = new ArrayList<MForm>();
        MIntegerInput input = new MIntegerInput("INTEGER-INPUT", false);
        input.setValue((Object)100);
        MStringInput strInput = new MStringInput("STRING-INPUT", false, 20);
        strInput.setValue((Object)"TEST-VALUE");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(input);
        list.add(strInput);
        MForm form = new MForm("FORMNAME", list);
        forms.add(form);
        return new MConnectionForms(forms);
    }

    private MConnectionForms forms2() {
        ArrayList<MForm> forms = new ArrayList<MForm>();
        MMapInput input = new MMapInput("MAP-INPUT", false);
        ArrayList<MMapInput> list = new ArrayList<MMapInput>();
        list.add(input);
        MForm form = new MForm("form", list);
        forms.add(form);
        return new MConnectionForms(forms);
    }
}

