/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.HashMap;
import org.apache.sqoop.json.ValidationBean;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.Validation;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Test;

public class TestValidationBean {
    @Test
    public void testSerialization() {
        ValidationBean bean = new ValidationBean(this.getValidation(Status.FINE), this.getValidation(Status.UNACCEPTABLE));
        JSONObject json = bean.extract(false);
        String string = json.toJSONString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)string);
        ValidationBean retrievedBean = new ValidationBean();
        retrievedBean.restore(retrievedJson);
        Assert.assertNull((Object)retrievedBean.getId());
        Validation.FormInput fa = new Validation.FormInput("f", "i");
        Validation.FormInput fb = new Validation.FormInput("f2", "i2");
        Validation connector = retrievedBean.getConnectorValidation();
        Assert.assertEquals((Object)Status.FINE, (Object)connector.getStatus());
        Assert.assertEquals((long)2L, (long)connector.getMessages().size());
        Assert.assertTrue((boolean)connector.getMessages().containsKey(fa));
        Assert.assertEquals((Object)new Validation.Message(Status.FINE, "d"), connector.getMessages().get(fa));
        Validation framework = retrievedBean.getFrameworkValidation();
        Assert.assertEquals((Object)Status.UNACCEPTABLE, (Object)framework.getStatus());
        Assert.assertEquals((long)2L, (long)framework.getMessages().size());
        Assert.assertTrue((boolean)framework.getMessages().containsKey(fb));
        Assert.assertEquals((Object)new Validation.Message(Status.UNACCEPTABLE, "c"), framework.getMessages().get(fb));
    }

    @Test
    public void testId() {
        ValidationBean bean = new ValidationBean(this.getValidation(Status.FINE), this.getValidation(Status.FINE));
        bean.setId(Long.valueOf(10L));
        JSONObject json = bean.extract(false);
        String string = json.toJSONString();
        JSONObject retrievedJson = (JSONObject)JSONValue.parse((String)string);
        ValidationBean retrievedBean = new ValidationBean();
        retrievedBean.restore(retrievedJson);
        Assert.assertEquals((Object)10L, (Object)retrievedBean.getId());
    }

    public Validation getValidation(Status status) {
        HashMap<Validation.FormInput, Validation.Message> messages = new HashMap<Validation.FormInput, Validation.Message>();
        messages.put(new Validation.FormInput("f", "i"), new Validation.Message(status, "d"));
        messages.put(new Validation.FormInput("f2", "i2"), new Validation.Message(status, "c"));
        return new Validation(status, messages);
    }
}

