/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.sqoop.common.MapContext;
import org.junit.Test;

public class TestMapContext {
    @Test
    public void testInitalization() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("testkey", "testvalue");
        MapContext mc = new MapContext(options);
        Assert.assertEquals((String)"testvalue", (String)mc.getString("testkey"));
    }

    @Test
    public void testGetString() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("testkey", "testvalue");
        MapContext mc = new MapContext(options);
        Assert.assertEquals((String)"testvalue", (String)mc.getString("testkey", "defaultValue"));
        Assert.assertEquals((String)"defaultValue", (String)mc.getString("wrongKey", "defaultValue"));
    }

    @Test
    public void testGetBoolean() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("testkey", "true");
        MapContext mc = new MapContext(options);
        Assert.assertEquals((boolean)true, (boolean)mc.getBoolean("testkey", false));
        Assert.assertEquals((boolean)false, (boolean)mc.getBoolean("wrongKey", false));
    }

    @Test
    public void testGetInt() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("testkey", "123");
        MapContext mc = new MapContext(options);
        Assert.assertEquals((int)123, (int)mc.getInt("testkey", 456));
        Assert.assertEquals((int)456, (int)mc.getInt("wrongKey", 456));
    }

    @Test
    public void testGetLong() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("testkey", "123");
        MapContext mc = new MapContext(options);
        Assert.assertEquals((long)123L, (long)mc.getLong("testkey", 456L));
        Assert.assertEquals((long)456L, (long)mc.getLong("wrongKey", 456L));
    }

    @Test
    public void testGetNestedProperties() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("sqooptest1", "value");
        options.put("sqooptest2", "value");
        options.put("testsqoop1", "value");
        options.put("testsqoop1", "value");
        MapContext mc = new MapContext(options);
        Map result = mc.getNestedProperties("sqoop");
        Assert.assertEquals((int)2, (int)result.size());
        Assert.assertTrue((boolean)result.containsKey("test1"));
        Assert.assertTrue((boolean)result.containsKey("test2"));
        Assert.assertFalse((boolean)result.containsKey("testsqoop1"));
        Assert.assertFalse((boolean)result.containsKey("testsqoop2"));
    }
}

