/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation.validators;

import java.util.LinkedList;
import java.util.List;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.validation.Message;
import org.apache.sqoop.validation.Status;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class AbstractValidator<T> {
    public static final String DEFAULT_STRING_ARGUMENT = "";
    private List<Message> messages;
    private Status status;
    private String stringArgument;

    public abstract void validate(T var1);

    public AbstractValidator() {
        this.reset();
    }

    protected void addMessage(Message msg) {
        this.status = Status.getWorstStatus(this.status, msg.getStatus());
        this.messages.add(msg);
    }

    protected void addMessage(Status status, String msg) {
        this.addMessage(new Message(status, msg));
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStringArgument(String arg) {
        this.stringArgument = arg;
    }

    public String getStringArgument() {
        return this.stringArgument;
    }

    public void reset() {
        this.messages = new LinkedList<Message>();
        this.status = Status.getDefault();
        this.stringArgument = DEFAULT_STRING_ARGUMENT;
    }
}

