/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.schema.SchemaError;
import org.apache.sqoop.schema.type.ColumnType;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class Column {
    String name;
    Boolean nullable;

    public Column(String name) {
        this(name, true);
    }

    public Column(String name, Boolean nullable) {
        if (StringUtils.isEmpty((String)name)) {
            throw new SqoopException((ErrorCode)SchemaError.SCHEMA_0001, "Column name: " + name);
        }
        this.name = name;
        this.setNullable(nullable);
    }

    public abstract ColumnType getType();

    public Column setNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "name=" + this.name + "," + "nullable=" + this.nullable + "," + "type=" + (Object)((Object)this.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column that = (Column)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.nullable != null ? !this.nullable.equals(that.nullable) : that.nullable != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.nullable != null ? this.nullable.hashCode() : 0);
        return result;
    }
}

