/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.utils.UrlSafeUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class MStringInput
extends MInput<String> {
    private final short maxLength;

    public MStringInput(String name, boolean sensitive, InputEditable editable, String overrides, short maxLength) {
        super(name, sensitive, editable, overrides);
        this.maxLength = maxLength;
    }

    public short getMaxLength() {
        return this.maxLength;
    }

    @Override
    public String getUrlSafeValueString() {
        return UrlSafeUtils.urlEncode((String)this.getValue());
    }

    @Override
    public void restoreFromUrlSafeValueString(String valueString) {
        this.setValue(UrlSafeUtils.urlDecode(valueString));
    }

    @Override
    public MInputType getType() {
        return MInputType.STRING;
    }

    @Override
    public boolean hasExtraInfo() {
        return true;
    }

    @Override
    public String getExtraInfoToString() {
        return Short.toString(this.getMaxLength());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MStringInput)) {
            return false;
        }
        MStringInput msi = (MStringInput)other;
        return this.getName().equals(msi.getName()) && this.isSensitive() == msi.isSensitive() && this.maxLength == msi.maxLength;
    }

    @Override
    public int hashCode() {
        int result = 23 + 31 * this.getName().hashCode();
        result = 31 * result + (this.isSensitive() ? 1 : 0);
        result = 31 * result + this.maxLength;
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public void setEmpty() {
        this.setValue(null);
    }

    @Override
    public MStringInput clone(boolean cloneWithValue) {
        MStringInput copy = new MStringInput(this.getName(), this.isSensitive(), this.getEditable(), this.getOverrides(), this.getMaxLength());
        copy.setPersistenceId(this.getPersistenceId());
        if (cloneWithValue) {
            copy.setValue(this.getValue());
        }
        return copy;
    }
}

