/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MToConfig;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MJob
extends MAccountableEntity
implements MClonable {
    private final long fromConnectorId;
    private final long toConnectorId;
    private final long fromLinkId;
    private final long toLinkId;
    private final MFromConfig fromConfig;
    private final MToConfig toConfig;
    private final MDriverConfig driverConfig;

    public MJob(long fromConnectorId, long toConnectorId, long fromLinkId, long toLinkId, MFromConfig fromConfig, MToConfig toConfig, MDriverConfig driverConfig) {
        this.fromConnectorId = fromConnectorId;
        this.toConnectorId = toConnectorId;
        this.fromLinkId = fromLinkId;
        this.toLinkId = toLinkId;
        this.fromConfig = fromConfig;
        this.toConfig = toConfig;
        this.driverConfig = driverConfig;
    }

    public MJob(MJob other) {
        this(other, other.getFromJobConfig().clone(true), other.getToJobConfig().clone(true), other.driverConfig.clone(true));
    }

    public MJob(MJob other, MFromConfig fromConfig, MToConfig toConfig, MDriverConfig driverConfig) {
        super(other);
        this.fromConnectorId = other.getFromConnectorId();
        this.toConnectorId = other.getToConnectorId();
        this.fromLinkId = other.getFromLinkId();
        this.toLinkId = other.getToLinkId();
        this.fromConfig = fromConfig;
        this.toConfig = toConfig;
        this.driverConfig = driverConfig;
        this.setPersistenceId(other.getPersistenceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("job");
        sb.append("From job config: ").append(this.getFromJobConfig());
        sb.append(", To job config: ").append(this.getToJobConfig());
        sb.append(", Driver config: ").append(this.driverConfig);
        return sb.toString();
    }

    public long getFromLinkId() {
        return this.fromLinkId;
    }

    public long getToLinkId() {
        return this.toLinkId;
    }

    public long getFromConnectorId() {
        return this.fromConnectorId;
    }

    public long getToConnectorId() {
        return this.toConnectorId;
    }

    public MFromConfig getFromJobConfig() {
        return this.fromConfig;
    }

    public MToConfig getToJobConfig() {
        return this.toConfig;
    }

    public MDriverConfig getDriverConfig() {
        return this.driverConfig;
    }

    @Override
    public MJob clone(boolean cloneWithValue) {
        if (cloneWithValue) {
            return new MJob(this);
        }
        return new MJob(this.getFromConnectorId(), this.getToConnectorId(), this.getFromLinkId(), this.getToLinkId(), this.getFromJobConfig().clone(false), this.getToJobConfig().clone(false), this.getDriverConfig().clone(false));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MJob)) {
            return false;
        }
        MJob job = (MJob)object;
        return job.getFromConnectorId() == this.getFromConnectorId() && job.getToConnectorId() == this.getToConnectorId() && job.getFromLinkId() == this.getFromLinkId() && job.getToLinkId() == this.getToLinkId() && job.getPersistenceId() == this.getPersistenceId() && job.getFromJobConfig().equals(this.getFromJobConfig()) && job.getToJobConfig().equals(this.getToJobConfig()) && job.getDriverConfig().equals(this.driverConfig);
    }
}

