/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MIntegerInput
extends MInput<Integer> {
    public MIntegerInput(String name, boolean sensitive, InputEditable editable, String overrides) {
        super(name, sensitive, editable, overrides);
    }

    @Override
    public String getUrlSafeValueString() {
        if (this.isEmpty()) {
            return "";
        }
        return ((Integer)this.getValue()).toString();
    }

    @Override
    public void restoreFromUrlSafeValueString(String valueString) {
        if (valueString.isEmpty()) {
            this.setEmpty();
        }
        this.setValue(Integer.valueOf(valueString));
    }

    @Override
    public MInputType getType() {
        return MInputType.INTEGER;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MIntegerInput)) {
            return false;
        }
        MIntegerInput i = (MIntegerInput)other;
        return this.getName().equals(i.getName());
    }

    @Override
    public int hashCode() {
        return 23 + 31 * this.getName().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public void setEmpty() {
        this.setValue(null);
    }

    @Override
    public MIntegerInput clone(boolean cloneWithValue) {
        MIntegerInput copy = new MIntegerInput(this.getName(), this.isSensitive(), this.getEditable(), this.getOverrides());
        copy.setPersistenceId(this.getPersistenceId());
        if (cloneWithValue) {
            copy.setValue(this.getValue());
        }
        return copy;
    }
}

