/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.JSONUtils;
import org.apache.sqoop.model.Config;
import org.apache.sqoop.model.ConfigClass;
import org.apache.sqoop.model.ConfigurationClass;
import org.apache.sqoop.model.Input;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MValidatedElement;
import org.apache.sqoop.model.ModelError;
import org.apache.sqoop.utils.ClassUtils;
import org.apache.sqoop.validation.ConfigValidationResult;
import org.apache.sqoop.validation.ConfigValidationRunner;
import org.apache.sqoop.validation.Message;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfigUtils {
    public static List<MConfig> toConfigs(Object configuration) {
        return ConfigUtils.toConfigs(configuration.getClass(), configuration);
    }

    public static List<MConfig> toConfigs(Class<?> klass) {
        return ConfigUtils.toConfigs(klass, null);
    }

    public static List<MConfig> toConfigs(Class<?> klass, Object configuration) {
        HashSet<String> configNames = new HashSet<String>();
        ConfigurationClass configurationClass = klass.getAnnotation(ConfigurationClass.class);
        if (configurationClass == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation ConfigurationClass on class " + klass.getName());
        }
        LinkedList<MConfig> configs = new LinkedList<MConfig>();
        for (Field field : klass.getDeclaredFields()) {
            field.setAccessible(true);
            Config configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            String configName = ConfigUtils.getConfigName(field, configAnnotation, configNames);
            Class<?> type = field.getType();
            Object value = null;
            if (configuration != null) {
                try {
                    value = field.get(configuration);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Can't retrieve value from " + field.getName(), e);
                }
            }
            configs.add(ConfigUtils.toConfig(configName, type, value));
        }
        return configs;
    }

    private static MConfig toConfig(String configName, Class klass, Object object) {
        ConfigClass global = klass.getAnnotation(ConfigClass.class);
        if (global == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation ConfigClass on class " + klass.getName());
        }
        LinkedList inputs = new LinkedList();
        for (Field field : klass.getDeclaredFields()) {
            MInput input;
            field.setAccessible(true);
            String fieldName = field.getName();
            String inputName = configName + "." + fieldName;
            Input inputAnnotation = field.getAnnotation(Input.class);
            if (inputAnnotation == null) continue;
            boolean sensitive = inputAnnotation.sensitive();
            short maxLen = inputAnnotation.size();
            InputEditable editable = inputAnnotation.editable();
            String overrides = inputAnnotation.overrides();
            Class<Map> type = field.getType();
            if (type.isPrimitive()) {
                throw new SqoopException((ErrorCode)ModelError.MODEL_007, "Detected primitive type " + type + " for field " + fieldName);
            }
            if (type == String.class) {
                input = new MStringInput(inputName, sensitive, editable, overrides, maxLen);
            } else if (type.isAssignableFrom(Map.class)) {
                input = new MMapInput(inputName, sensitive, editable, overrides);
            } else if (type == Integer.class) {
                input = new MIntegerInput(inputName, sensitive, editable, overrides);
            } else if (type == Long.class) {
                input = new MLongInput(inputName, sensitive, editable, overrides);
            } else if (type == Boolean.class) {
                input = new MBooleanInput(inputName, sensitive, editable, overrides);
            } else if (type.isEnum()) {
                input = new MEnumInput(inputName, sensitive, editable, overrides, ClassUtils.getEnumStrings(type));
            } else {
                throw new SqoopException((ErrorCode)ModelError.MODEL_004, "Unsupported type " + type.getName() + " for input " + fieldName);
            }
            if (object != null) {
                Object value;
                try {
                    value = field.get(object);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Can't retrieve value from " + field.getName(), e);
                }
                if (value == null) {
                    ((MInput)input).setEmpty();
                } else {
                    input.setValue(value);
                }
            }
            inputs.add(input);
        }
        MConfig config = new MConfig(configName, inputs);
        for (MInput<?> input : config.getInputs()) {
            ConfigUtils.validateInputOverridesAttribute(input, config);
        }
        return config;
    }

    private static Field getFieldFromName(Class<?> klass, String name) {
        Field configField;
        try {
            configField = klass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (name != null) {
                for (Field field : klass.getDeclaredFields()) {
                    Config configAnnotation = field.getAnnotation(Config.class);
                    if (configAnnotation == null || StringUtils.isEmpty((String)configAnnotation.name()) || !name.equals(configAnnotation.name())) continue;
                    return field;
                }
            }
            throw new SqoopException(ModelError.MODEL_006, "Missing field " + name + " on config class " + klass.getCanonicalName(), e);
        }
        return configField;
    }

    public static ConfigValidationResult validateConfigs(List<MConfig> configs, Class configClass) {
        ConfigValidationRunner validationRunner = new ConfigValidationRunner();
        Object configInstance = ConfigUtils.fromConfigs(configs, configClass);
        return validationRunner.validate(configInstance);
    }

    public static Object fromConfigs(List<MConfig> configs, Class configClass) {
        Object configInstance = ClassUtils.instantiate(configClass, new Object[0]);
        if (configInstance == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_016, configClass.getCanonicalName());
        }
        ConfigUtils.fromConfigs(configs, configInstance);
        return configInstance;
    }

    public static void fromConfigs(List<MConfig> configs, Object configuration) {
        Class<?> klass = configuration.getClass();
        for (MConfig config : configs) {
            Field configField;
            try {
                configField = klass.getDeclaredField(config.getName());
            }
            catch (NoSuchFieldException e) {
                throw new SqoopException(ModelError.MODEL_006, "Missing field " + config.getName() + " on config class " + klass.getCanonicalName(), e);
            }
            configField = ConfigUtils.getFieldFromName(klass, config.getName());
            configField.setAccessible(true);
            Class<?> configClass = configField.getType();
            Object newValue = ClassUtils.instantiate(configClass, new Object[0]);
            if (newValue == null) {
                throw new SqoopException((ErrorCode)ModelError.MODEL_006, "Can't instantiate new config " + configClass);
            }
            for (MInput<?> input : config.getInputs()) {
                Field inputField;
                String[] splitNames = input.getName().split("\\.");
                if (splitNames.length != 2) {
                    throw new SqoopException((ErrorCode)ModelError.MODEL_009, "Invalid name: " + input.getName());
                }
                String inputName = splitNames[1];
                try {
                    inputField = configClass.getDeclaredField(inputName);
                }
                catch (NoSuchFieldException e) {
                    throw new SqoopException(ModelError.MODEL_006, "Missing field " + input.getName(), e);
                }
                inputField.setAccessible(true);
                try {
                    if (input.isEmpty()) {
                        inputField.set(newValue, null);
                        continue;
                    }
                    if (input.getType() == MInputType.ENUM) {
                        inputField.set(newValue, Enum.valueOf(inputField.getType(), (String)input.getValue()));
                        continue;
                    }
                    inputField.set(newValue, input.getValue());
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Issue with field " + inputField.getName(), e);
                }
            }
            try {
                configField.set(configuration, newValue);
            }
            catch (IllegalAccessException e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + configField.getName(), e);
            }
        }
    }

    public static void applyValidation(List<MConfig> configs, ConfigValidationResult result) {
        for (MConfig config : configs) {
            ConfigUtils.applyValidation(config, result);
            for (MInput<?> input : config.getInputs()) {
                ConfigUtils.applyValidation(input, result);
            }
        }
    }

    public static void applyValidation(MValidatedElement element, ConfigValidationResult result) {
        List<Message> messages = result.getMessages().get(element.getName());
        if (messages != null) {
            element.setValidationMessages(messages);
        } else {
            element.resetValidationMessages();
        }
    }

    public static String toJson(Object configuration) {
        Class<?> klass = configuration.getClass();
        HashSet<String> configNames = new HashSet<String>();
        ConfigurationClass configurationClass = klass.getAnnotation(ConfigurationClass.class);
        if (configurationClass == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation ConfigurationGroup on class " + klass.getName());
        }
        JSONObject jsonOutput = new JSONObject();
        for (Field configField : klass.getDeclaredFields()) {
            Object configValue;
            configField.setAccessible(true);
            Config configAnnotation = configField.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            String configName = ConfigUtils.getConfigName(configField, configAnnotation, configNames);
            try {
                configValue = configField.get(configuration);
            }
            catch (IllegalAccessException e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + configName, e);
            }
            JSONObject jsonConfig = new JSONObject();
            for (Field inputField : configField.getType().getDeclaredFields()) {
                Object value;
                inputField.setAccessible(true);
                String inputName = inputField.getName();
                try {
                    value = inputField.get(configValue);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Issue with field " + configName + "." + inputName, e);
                }
                Input inputAnnotation = inputField.getAnnotation(Input.class);
                if (inputAnnotation == null || value == null) continue;
                Class<Map> type = inputField.getType();
                if (type.isPrimitive()) {
                    throw new SqoopException((ErrorCode)ModelError.MODEL_007, "Detected primitive type " + type + " for field " + configName + "." + inputName);
                }
                if (type == String.class) {
                    jsonConfig.put((Object)inputName, value);
                    continue;
                }
                if (type.isAssignableFrom(Map.class)) {
                    JSONObject map = new JSONObject();
                    for (Object key : ((Map)value).keySet()) {
                        map.put(key, ((Map)value).get(key));
                    }
                    jsonConfig.put((Object)inputName, (Object)map);
                    continue;
                }
                if (type == Integer.class || type == Long.class) {
                    jsonConfig.put((Object)inputName, value);
                    continue;
                }
                if (type.isEnum()) {
                    jsonConfig.put((Object)inputName, (Object)value.toString());
                    continue;
                }
                if (type == Boolean.class) {
                    jsonConfig.put((Object)inputName, value);
                    continue;
                }
                throw new SqoopException((ErrorCode)ModelError.MODEL_004, "Unsupported type " + type.getName() + " for input " + configName + "." + inputName);
            }
            jsonOutput.put((Object)configName, (Object)jsonConfig);
        }
        return jsonOutput.toJSONString();
    }

    public static void fillValues(String json, Object configuration) {
        Class<?> klass = configuration.getClass();
        HashSet<String> configNames = new HashSet<String>();
        JSONObject jsonConfigs = JSONUtils.parse(json);
        for (Field configField : klass.getDeclaredFields()) {
            Object configValue;
            configField.setAccessible(true);
            String configName = configField.getName();
            Config configAnnotation = configField.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            configName = ConfigUtils.getConfigName(configField, configAnnotation, configNames);
            try {
                configField.set(configuration, configField.getType().newInstance());
            }
            catch (Exception e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + configName, e);
            }
            JSONObject jsonInputs = (JSONObject)jsonConfigs.get((Object)configField.getName());
            if (jsonInputs == null) continue;
            try {
                configValue = configField.get(configuration);
            }
            catch (IllegalAccessException e) {
                throw new SqoopException(ModelError.MODEL_005, "Issue with field " + configName, e);
            }
            for (Field inputField : configField.getType().getDeclaredFields()) {
                inputField.setAccessible(true);
                String inputName = inputField.getName();
                Input inputAnnotation = inputField.getAnnotation(Input.class);
                if (inputAnnotation == null || jsonInputs.get((Object)inputName) == null) {
                    try {
                        inputField.set(configValue, null);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new SqoopException(ModelError.MODEL_005, "Issue with field " + configName + "." + inputName, e);
                    }
                }
                Class<Map> type = inputField.getType();
                try {
                    if (type == String.class) {
                        inputField.set(configValue, jsonInputs.get((Object)inputName));
                        continue;
                    }
                    if (type.isAssignableFrom(Map.class)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        JSONObject jsonObject = (JSONObject)jsonInputs.get((Object)inputName);
                        for (Object key : jsonObject.keySet()) {
                            map.put((String)key, (String)jsonObject.get(key));
                        }
                        inputField.set(configValue, map);
                        continue;
                    }
                    if (type == Integer.class) {
                        inputField.set(configValue, ((Long)jsonInputs.get((Object)inputName)).intValue());
                        continue;
                    }
                    if (type == Long.class) {
                        inputField.set(configValue, (long)((Long)jsonInputs.get((Object)inputName)));
                        continue;
                    }
                    if (type.isEnum()) {
                        inputField.set(configValue, Enum.valueOf(inputField.getType(), (String)jsonInputs.get((Object)inputName)));
                        continue;
                    }
                    if (type == Boolean.class) {
                        inputField.set(configValue, (Boolean)jsonInputs.get((Object)inputName));
                        continue;
                    }
                    throw new SqoopException((ErrorCode)ModelError.MODEL_004, "Unsupported type " + type.getName() + " for input " + configName + "." + inputName);
                }
                catch (IllegalAccessException e) {
                    throw new SqoopException(ModelError.MODEL_005, "Issue with field " + configName + "." + inputName, e);
                }
            }
        }
    }

    private static String getConfigName(Field member, Config annotation, Set<String> existingConfigNames) {
        if (StringUtils.isEmpty((String)annotation.name())) {
            return member.getName();
        }
        ConfigUtils.checkForValidConfigName(existingConfigNames, annotation.name());
        existingConfigNames.add(annotation.name());
        return annotation.name();
    }

    private static void checkForValidConfigName(Set<String> existingConfigNames, String customConfigName) {
        if (existingConfigNames.contains(customConfigName)) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_012, "Issue with field config name " + customConfigName);
        }
        if (!Character.isJavaIdentifierStart(customConfigName.toCharArray()[0])) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_013, "Issue with field config name " + customConfigName);
        }
        char[] arr$ = customConfigName.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (Character.isJavaIdentifierPart(c.charValue())) continue;
            throw new SqoopException((ErrorCode)ModelError.MODEL_013, "Issue with field config name " + customConfigName);
        }
        if (customConfigName.length() > 30) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_014, "Issue with field config name " + customConfigName);
        }
    }

    public static String getName(Field input, Input annotation) {
        return input.getName();
    }

    public static String getName(Field config, Config annotation) {
        return config.getName();
    }

    public static ConfigurationClass getConfigurationClassAnnotation(Object object, boolean strict) {
        ConfigurationClass annotation = object.getClass().getAnnotation(ConfigurationClass.class);
        if (strict && annotation == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation ConfigurationGroupClass on class " + object.getClass().getName());
        }
        return annotation;
    }

    public static ConfigClass getConfigClassAnnotation(Object object, boolean strict) {
        ConfigClass annotation = object.getClass().getAnnotation(ConfigClass.class);
        if (strict && annotation == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation ConfigurationGroupClass on class " + object.getClass().getName());
        }
        return annotation;
    }

    public static Config getConfigAnnotation(Field field, boolean strict) {
        Config annotation = field.getAnnotation(Config.class);
        if (strict && annotation == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation Config on Field " + field.getName() + " on class " + field.getDeclaringClass().getName());
        }
        return annotation;
    }

    public static Input getInputAnnotation(Field field, boolean strict) {
        Input annotation = field.getAnnotation(Input.class);
        if (strict && annotation == null) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_003, "Missing annotation Input on Field " + field.getName() + " on class " + field.getDeclaringClass().getName());
        }
        return annotation;
    }

    public static Object getFieldValue(Field field, Object object) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new SqoopException((ErrorCode)ModelError.MODEL_015, (Throwable)e);
        }
    }

    public static void validateInputOverridesAttribute(MInput<?> currentInput, MConfig config) {
        String[] overrideInputs;
        String overrides = currentInput.getOverrides();
        if (StringUtils.isEmpty((String)overrides)) {
            return;
        }
        for (String override : overrideInputs = overrides.split("\\,")) {
            if (!config.getInputNames().contains(override)) {
                throw new SqoopException((ErrorCode)ModelError.MODEL_017, "for input :" + currentInput.toString());
            }
            if (override.equals(currentInput.getName())) {
                throw new SqoopException((ErrorCode)ModelError.MODEL_018, "for input :" + currentInput.toString());
            }
            if (!currentInput.getEditable().equals((Object)InputEditable.USER_ONLY) || !config.getUserOnlyEditableInputNames().contains(override)) continue;
            throw new SqoopException((ErrorCode)ModelError.MODEL_019, "for input :" + currentInput.toString());
        }
    }
}

