/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.HashSet;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.NullSchema;
import org.apache.sqoop.schema.Schema;
import org.apache.sqoop.schema.type.AbstractComplexListType;
import org.apache.sqoop.schema.type.AbstractPrimitiveType;
import org.apache.sqoop.schema.type.AbstractString;
import org.apache.sqoop.schema.type.Array;
import org.apache.sqoop.schema.type.Binary;
import org.apache.sqoop.schema.type.Bit;
import org.apache.sqoop.schema.type.Column;
import org.apache.sqoop.schema.type.ColumnType;
import org.apache.sqoop.schema.type.Date;
import org.apache.sqoop.schema.type.DateTime;
import org.apache.sqoop.schema.type.Decimal;
import org.apache.sqoop.schema.type.Enum;
import org.apache.sqoop.schema.type.FixedPoint;
import org.apache.sqoop.schema.type.FloatingPoint;
import org.apache.sqoop.schema.type.Map;
import org.apache.sqoop.schema.type.Set;
import org.apache.sqoop.schema.type.Text;
import org.apache.sqoop.schema.type.Time;
import org.apache.sqoop.schema.type.Unknown;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchemaSerialization {
    private static final String NAME = "name";
    private static final String CREATION_DATE = "created";
    private static final String NOTE = "note";
    private static final String COLUMNS = "columns";
    private static final String TYPE = "type";
    private static final String NULLABLE = "nullable";
    private static final String SIZE = "size";
    private static final String MAP = "map";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String LIST = "list";
    private static final String LIST_TYPE = "listType";
    private static final String ENUM_OPTIONS = "options";
    private static final String BYTE_SIZE = "byteSize";
    private static final String CHAR_SIZE = "charSize";
    private static final String FRACTION = "fraction";
    private static final String TIMEZONE = "timezone";
    private static final String PRECISION = "precision";
    private static final String SCALE = "scale";
    private static final String SIGNED = "signed";
    private static final String JDBC_TYPE = "jdbc-type";

    public static JSONObject extractSchema(Schema schema) {
        JSONObject object = new JSONObject();
        if (schema != null) {
            object.put((Object)NAME, (Object)schema.getName());
            object.put((Object)CREATION_DATE, (Object)schema.getCreationDate().getTime());
            if (schema.getNote() != null) {
                object.put((Object)NOTE, (Object)schema.getNote());
            }
            JSONArray columnArray = new JSONArray();
            for (Column column : schema.getColumnsArray()) {
                columnArray.add((Object)SchemaSerialization.extractColumn(column));
            }
            object.put((Object)COLUMNS, (Object)columnArray);
        }
        return object;
    }

    public static Schema restoreSchema(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isEmpty()) {
            return NullSchema.getInstance();
        }
        String name = (String)jsonObject.get((Object)NAME);
        String note = (String)jsonObject.get((Object)NOTE);
        java.util.Date date = new java.util.Date((Long)jsonObject.get((Object)CREATION_DATE));
        Schema schema = new Schema(name).setNote(note).setCreationDate(date);
        JSONArray columnsArray = (JSONArray)jsonObject.get((Object)COLUMNS);
        for (Object obj : columnsArray) {
            schema.addColumn(SchemaSerialization.restoreColumn((JSONObject)obj));
        }
        return schema;
    }

    private static JSONObject extractColumn(Column column) {
        JSONObject ret = new JSONObject();
        ret.put((Object)NAME, (Object)column.getName());
        ret.put((Object)NULLABLE, (Object)column.isNullable());
        ret.put((Object)TYPE, (Object)column.getType().name());
        switch (column.getType()) {
            case MAP: {
                JSONObject map = new JSONObject();
                ret.put((Object)MAP, (Object)map);
                map.put((Object)KEY, (Object)SchemaSerialization.extractColumn(((Map)column).getKey()));
                map.put((Object)VALUE, (Object)SchemaSerialization.extractColumn(((Map)column).getValue()));
                break;
            }
            case ENUM: {
                JSONObject enumList = new JSONObject();
                ret.put((Object)LIST, (Object)enumList);
                JSONArray optionsArray = new JSONArray();
                optionsArray.addAll(((Enum)column).getOptions());
                enumList.put((Object)ENUM_OPTIONS, (Object)optionsArray);
                break;
            }
            case SET: {
                JSONObject set = new JSONObject();
                ret.put((Object)LIST, (Object)set);
                set.put((Object)LIST_TYPE, (Object)SchemaSerialization.extractColumn(((AbstractComplexListType)column).getListType()));
                break;
            }
            case ARRAY: {
                JSONObject arrayList = new JSONObject();
                ret.put((Object)LIST, (Object)arrayList);
                arrayList.put((Object)SIZE, (Object)((Array)column).getSize());
                arrayList.put((Object)LIST_TYPE, (Object)SchemaSerialization.extractColumn(((Array)column).getListType()));
                break;
            }
            case BINARY: 
            case TEXT: {
                ret.put((Object)CHAR_SIZE, (Object)((AbstractString)column).getCharSize());
                break;
            }
            case DATE_TIME: {
                ret.put((Object)FRACTION, (Object)((DateTime)column).hasFraction());
                ret.put((Object)TIMEZONE, (Object)((DateTime)column).hasTimezone());
                break;
            }
            case DECIMAL: {
                ret.put((Object)PRECISION, (Object)((Decimal)column).getPrecision());
                ret.put((Object)SCALE, (Object)((Decimal)column).getScale());
                break;
            }
            case FIXED_POINT: {
                ret.put((Object)BYTE_SIZE, (Object)((FixedPoint)column).getByteSize());
                ret.put((Object)SIGNED, (Object)((FixedPoint)column).isSigned());
                break;
            }
            case FLOATING_POINT: {
                ret.put((Object)BYTE_SIZE, (Object)((FloatingPoint)column).getByteSize());
                break;
            }
            case TIME: {
                ret.put((Object)FRACTION, (Object)((Time)column).hasFraction());
                break;
            }
            case UNKNOWN: {
                ret.put((Object)JDBC_TYPE, (Object)((Unknown)column).getJdbcType());
                break;
            }
            case DATE: 
            case BIT: {
                break;
            }
        }
        return ret;
    }

    private static Column restoreColumn(JSONObject obj) {
        String name = (String)obj.get((Object)NAME);
        Boolean nullable = (Boolean)obj.get((Object)NULLABLE);
        AbstractPrimitiveType key = null;
        Column value = null;
        Long arraySize = null;
        Column listType = null;
        HashSet<String> options = new HashSet<String>();
        if (obj.containsKey((Object)MAP)) {
            JSONObject map = (JSONObject)obj.get((Object)MAP);
            if (map.containsKey((Object)KEY)) {
                key = (AbstractPrimitiveType)SchemaSerialization.restoreColumn((JSONObject)map.get((Object)KEY));
            }
            if (map.containsKey((Object)VALUE)) {
                value = SchemaSerialization.restoreColumn((JSONObject)map.get((Object)VALUE));
            }
        }
        if (obj.containsKey((Object)LIST)) {
            JSONObject list = (JSONObject)obj.get((Object)LIST);
            if (list.containsKey((Object)LIST_TYPE)) {
                listType = SchemaSerialization.restoreColumn((JSONObject)list.get((Object)LIST_TYPE));
            }
            arraySize = (Long)list.get((Object)SIZE);
            if (list.containsKey((Object)ENUM_OPTIONS)) {
                JSONArray optionsArray = (JSONArray)list.get((Object)ENUM_OPTIONS);
                for (int n = 0; n < optionsArray.size(); ++n) {
                    options.add((String)optionsArray.get(n));
                }
            }
        }
        ColumnType type = ColumnType.valueOf((String)obj.get((Object)TYPE));
        Column output = null;
        switch (type) {
            case ARRAY: {
                output = new Array(name, listType).setSize(arraySize);
                break;
            }
            case BINARY: {
                Long charSize = (Long)obj.get((Object)CHAR_SIZE);
                output = new Binary(name).setCharSize(charSize);
                break;
            }
            case BIT: {
                output = new Bit(name);
                break;
            }
            case DATE: {
                output = new Date(name);
                break;
            }
            case DATE_TIME: {
                Boolean hasFraction = (Boolean)obj.get((Object)FRACTION);
                Boolean hasTimezone = (Boolean)obj.get((Object)TIMEZONE);
                output = new DateTime(name, hasFraction, hasTimezone);
                break;
            }
            case DECIMAL: {
                Integer precision = obj.get((Object)PRECISION) != null ? Integer.valueOf(((Long)obj.get((Object)PRECISION)).intValue()) : null;
                Integer scale = obj.get((Object)SCALE) != null ? Integer.valueOf(((Long)obj.get((Object)SCALE)).intValue()) : null;
                output = new Decimal(name, precision, scale);
                break;
            }
            case ENUM: {
                output = new Enum(name, options);
                break;
            }
            case FIXED_POINT: {
                Boolean signed = (Boolean)obj.get((Object)SIGNED);
                Long fixedPointByteSize = (Long)obj.get((Object)BYTE_SIZE);
                output = new FixedPoint(name, fixedPointByteSize, signed);
                break;
            }
            case FLOATING_POINT: {
                Long floatingPointByteSize = (Long)obj.get((Object)BYTE_SIZE);
                output = new FloatingPoint(name, floatingPointByteSize);
                break;
            }
            case MAP: {
                output = new Map(name, key, value);
                break;
            }
            case SET: {
                output = new Set(name, listType);
                break;
            }
            case TEXT: {
                Long charSize = (Long)obj.get((Object)CHAR_SIZE);
                output = new Text(name).setCharSize(charSize);
                break;
            }
            case TIME: {
                Boolean hasTimeFraction = (Boolean)obj.get((Object)FRACTION);
                output = new Time(name, hasTimeFraction);
                break;
            }
            case UNKNOWN: {
                Long jdbcType = (Long)obj.get((Object)JDBC_TYPE);
                output = new Unknown(name).setJdbcType(jdbcType);
                break;
            }
        }
        output.setNullable(nullable);
        return output;
    }

    private SchemaSerialization() {
    }
}

