/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.json.util.SerializationError;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConfigType;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MPersistableEntity;
import org.apache.sqoop.model.MStringInput;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ConfigInputSerialization {
    public static JSONArray extractConfigList(List<MConfig> mConfigs, MConfigType type, boolean skipSensitive) {
        JSONArray configs = new JSONArray();
        for (MConfig mConfig : mConfigs) {
            configs.add((Object)ConfigInputSerialization.extractConfig(mConfig, type, skipSensitive));
        }
        return configs;
    }

    static JSONObject extractConfig(MConfig mConfig, MConfigType type, boolean skipSensitive) {
        JSONObject config = new JSONObject();
        config.put((Object)"id", (Object)mConfig.getPersistenceId());
        config.put((Object)"name", (Object)mConfig.getName());
        config.put((Object)"type", (Object)type.name());
        JSONArray mInputs = new JSONArray();
        config.put((Object)"inputs", (Object)mInputs);
        for (MInput<?> mInput : mConfig.getInputs()) {
            JSONObject input = new JSONObject();
            input.put((Object)"id", (Object)mInput.getPersistenceId());
            input.put((Object)"name", (Object)mInput.getName());
            input.put((Object)"type", (Object)mInput.getType().toString());
            input.put((Object)"sensitive", (Object)mInput.isSensitive());
            input.put((Object)"editable", (Object)mInput.getEditable().name());
            input.put((Object)"overrides", (Object)mInput.getOverrides());
            if (mInput.getType() == MInputType.STRING) {
                input.put((Object)"size", (Object)((MStringInput)mInput).getMaxLength());
            }
            if (mInput.getType() == MInputType.ENUM) {
                input.put((Object)"values", (Object)StringUtils.join((Object[])((MEnumInput)mInput).getValues(), (String)","));
            }
            if (!(mInput.isEmpty() || skipSensitive && mInput.isSensitive())) {
                if (mInput.getType() == MInputType.MAP) {
                    input.put((Object)"value", mInput.getValue());
                } else {
                    input.put((Object)"value", (Object)mInput.getUrlSafeValueString());
                }
            }
            mInputs.add((Object)input);
        }
        return config;
    }

    public static List<MConfig> restoreConfigList(JSONArray configs) {
        ArrayList<MConfig> mConfigs = new ArrayList<MConfig>();
        for (int i = 0; i < configs.size(); ++i) {
            mConfigs.add(ConfigInputSerialization.restoreConfig((JSONObject)configs.get(i)));
        }
        return mConfigs;
    }

    static MConfig restoreConfig(JSONObject config) {
        JSONArray inputs = (JSONArray)config.get((Object)"inputs");
        ArrayList mInputs = new ArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            JSONObject input = (JSONObject)inputs.get(i);
            MInputType type = MInputType.valueOf((String)input.get((Object)"type"));
            String name = (String)input.get((Object)"name");
            Boolean sensitive = (Boolean)input.get((Object)"sensitive");
            InputEditable editable = input.containsKey((Object)"editable") ? InputEditable.valueOf((String)input.get((Object)"editable")) : InputEditable.USER_ONLY;
            String overrides = (String)input.get((Object)"overrides");
            MPersistableEntity mInput = null;
            switch (type) {
                case STRING: {
                    long size = (Long)input.get((Object)"size");
                    mInput = new MStringInput(name, sensitive, editable, overrides, (short)size);
                    break;
                }
                case MAP: {
                    mInput = new MMapInput(name, sensitive, editable, overrides);
                    break;
                }
                case INTEGER: {
                    mInput = new MIntegerInput(name, sensitive, editable, overrides);
                    break;
                }
                case LONG: {
                    mInput = new MLongInput(name, sensitive, editable, overrides);
                    break;
                }
                case BOOLEAN: {
                    mInput = new MBooleanInput(name, sensitive, editable, overrides);
                    break;
                }
                case ENUM: {
                    String values = (String)input.get((Object)"values");
                    mInput = new MEnumInput(name, sensitive, editable, overrides, values.split(","));
                    break;
                }
            }
            mInput.setPersistenceId((Long)input.get((Object)"id"));
            if (input.containsKey((Object)"value")) {
                switch (type) {
                    case MAP: {
                        try {
                            ((MInput)mInput).setValue((Map)input.get((Object)"value"));
                            break;
                        }
                        catch (ClassCastException e) {
                            throw new SqoopException((ErrorCode)SerializationError.SERIALIZATION_001, name + " requires a 'map' value.");
                        }
                    }
                    default: {
                        ((MInput)mInput).restoreFromUrlSafeValueString((String)input.get((Object)"value"));
                    }
                }
            }
            mInputs.add((MInput<?>)mInput);
        }
        MConfig mConfig = new MConfig((String)config.get((Object)"name"), mInputs);
        mConfig.setPersistenceId((Long)config.get((Object)"id"));
        return mConfig;
    }

    private ConfigInputSerialization() {
    }
}

