/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JsonBean;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class VersionBean
implements JsonBean {
    public static final String BUILD_VERSION = "build-version";
    public static final String SOURCE_REVISION = "source-revision";
    public static final String BUILD_DATE = "build-date";
    public static final String SYSTEM_USER_NAME = "user";
    public static final String SOURCE_URL = "source-url";
    public static final String SUPPORTED_API_VERSIONS = "api-versions";
    private String buildVersion;
    private String sourceRevision;
    private String buildDate;
    private String systemUser;
    private String sourceUrl;
    private String[] supportedRestAPIVersions;

    public VersionBean(String serverVersion, String sourceRevision, String buildDate, String user, String sourceUrl, String[] supportedAPIVersions) {
        this.buildVersion = serverVersion;
        this.sourceRevision = sourceRevision;
        this.buildDate = buildDate;
        this.systemUser = user;
        this.sourceUrl = sourceUrl;
        this.supportedRestAPIVersions = new String[supportedAPIVersions.length];
        System.arraycopy(supportedAPIVersions, 0, this.supportedRestAPIVersions, 0, supportedAPIVersions.length);
    }

    public VersionBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject result = new JSONObject();
        result.put((Object)BUILD_VERSION, (Object)this.buildVersion);
        result.put((Object)SOURCE_REVISION, (Object)this.sourceRevision);
        result.put((Object)BUILD_DATE, (Object)this.buildDate);
        result.put((Object)SYSTEM_USER_NAME, (Object)this.systemUser);
        result.put((Object)SOURCE_URL, (Object)this.sourceUrl);
        JSONArray apiVersionsArray = new JSONArray();
        for (String version : this.supportedRestAPIVersions) {
            apiVersionsArray.add((Object)version);
        }
        result.put((Object)SUPPORTED_API_VERSIONS, (Object)apiVersionsArray);
        return result;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.buildVersion = (String)jsonObject.get((Object)BUILD_VERSION);
        this.sourceRevision = (String)jsonObject.get((Object)SOURCE_REVISION);
        this.buildDate = (String)jsonObject.get((Object)BUILD_DATE);
        this.systemUser = (String)jsonObject.get((Object)SYSTEM_USER_NAME);
        this.sourceUrl = (String)jsonObject.get((Object)SOURCE_URL);
        JSONArray apiVersionsArray = (JSONArray)jsonObject.get((Object)SUPPORTED_API_VERSIONS);
        int size = apiVersionsArray.size();
        this.supportedRestAPIVersions = new String[size];
        for (int i = 0; i < size; ++i) {
            this.supportedRestAPIVersions[i] = (String)apiVersionsArray.get(i);
        }
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getSourceRevision() {
        return this.sourceRevision;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getSystemUser() {
        return this.systemUser;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String[] getSupportedAPIVersions() {
        return this.supportedRestAPIVersions;
    }
}

